/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public abstract class A_VarManager<T extends I_Object> {
    private final A_VarManager<T> parent;
    private final ArrayList<String> vars_name = new ArrayList();
    private final ArrayList<String> vars_real = new ArrayList();
    private final ArrayList<T> vars_T = new ArrayList();

    public A_VarManager(A_VarManager<T> parent) {
        this.parent = parent;
    }

    public int count() {
        return this.vars_name.size();
    }

    public T create(String name, DebugInfo debug) {
        T vo = this.iUse(name, false);
        if (vo != null) {
            return vo;
        }
        String rawname = name;
        while (rawname.charAt(rawname.length() - 1) == '?') {
            rawname = rawname.substring(0, rawname.length() - 1);
        }
        while (rawname.charAt(rawname.length() - 1) == '\u00bf') {
            rawname = rawname.substring(0, rawname.length() - 1);
        }
        if (this.knowsRaw(rawname)) {
            throw new ParseError("Raw name of variable already used!", name, debug);
        }
        vo = this.pCreateNew(name);
        this.vars_name.add(name);
        this.vars_real.add(rawname);
        this.vars_T.add(vo);
        return vo;
    }

    public void describe(CurProc cp, int depth) {
        for (I_Object t : this.vars_T) {
            t.describe(cp, depth);
        }
    }

    public void describe(int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "Items:");
        if (!this.vars_T.isEmpty()) {
            for (I_Object t : this.vars_T) {
                MOut.text(String.valueOf(space) + t.toString());
            }
        } else {
            MOut.text(String.valueOf(space) + "  none");
        }
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  none");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public boolean knows(String name) {
        if (this.vars_name.contains(name)) {
            return true;
        }
        return this.parent != null && this.parent.knows(name);
    }

    public boolean knowsRaw(String rawname) {
        if (this.vars_real.contains(rawname)) {
            return true;
        }
        return this.parent != null && this.parent.knowsRaw(rawname);
    }

    public T use(String name) {
        return this.iUse(name, true);
    }

    protected abstract T pCreateNew(String var1);

    private T iUse(String name, boolean error) {
        if (this.parent == this) {
            Err.invalid(name);
        }
        if (this.vars_name.contains(name)) {
            int idx = this.vars_name.indexOf(name);
            return (T)((I_Object)this.vars_T.get(idx));
        }
        if (this.parent != null && this.parent.knows(name)) {
            return this.parent.use(name);
        }
        if (error) {
            throw Err.forbidden("Access to unknown variable: " + name);
        }
        return null;
    }
}

