/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.For;
import org.jmo_lang.object.passthrough.Group;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_ShortCuts
implements I_ParseObject {
    private boolean group_ok = true;
    private boolean list_ok = true;
    private boolean for_ok = true;

    public void strict(boolean group, boolean list, boolean fo) {
        this.group_ok = group;
        this.list_ok = list;
        this.for_ok = fo;
    }

    @Override
    public boolean hits(char c0, Block current, String s) {
        switch (c0) {
            case '(': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(App app, Block current, String s, DebugInfo debugInfo) {
        switch (s.charAt(0)) {
            case '(': {
                return this.parseGroup(app, current, s, debugInfo);
            }
            case '[': {
                return this.parseList(app, current, s, debugInfo);
            }
            case '{': {
                return this.parseFor(app, current, s, debugInfo);
            }
        }
        throw Err.impossible(s);
    }

    public Group2<I_Object, String> parseGroup(App app, Block current, String s, DebugInfo debugInfo) {
        if (!this.group_ok) {
            throw new ParseError("Strict: Shortcut of group is forbidden. Use Group()!", s, debugInfo);
        }
        String group = Lib_Parser.group('(', ')', s, debugInfo);
        String rem = s.substring(group.length() + 2);
        Call par = Parser_Call.parseCall(app, current, group, debugInfo);
        return new Group2<I_Object, String>(new Group(par), ".do" + rem);
    }

    public Group2<I_Object, String> parseList(App app, Block current, String s, DebugInfo debugInfo) {
        if (!this.list_ok) {
            throw new ParseError("Strict: Shortcut of list is forbidden. Use List()!", s, debugInfo);
        }
        String list = Lib_Parser.group('[', ']', s, debugInfo);
        String rem = s.substring(list.length() + 2);
        Call[] pars = Parser_Call.parseParameter(app, current, list, debugInfo);
        return new Group2<I_Object, String>(new NonAtomic(JMo_List.class, pars, debugInfo), rem);
    }

    public Group2<I_Object, String> parseFor(App app, Block current, String s, DebugInfo debugInfo) {
        if (!this.for_ok) {
            throw new ParseError("Strict: Shortcut of For is forbidden. Use For()!", s, debugInfo);
        }
        String part = Lib_Parser.group('{', '}', s, debugInfo);
        String rem = s.substring(1 + part.length() + 1);
        Call[] pars = Parser_Call.parseParameter(app, current, part, debugInfo);
        Call from = pars[0];
        Call to = pars.length >= 2 ? pars[1] : null;
        Call step = pars.length == 3 ? pars[2] : null;
        rem = Lib_Parser.shortcutVarLet(rem);
        return new Group2<I_Object, String>(new NonAtomic(For.class, new Call[]{from, to, step}, debugInfo), ".do" + rem);
    }
}

