/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.pseudo.MC_BLOCK;
import org.jmo_lang.object.pseudo.MC_DEBUG;
import org.jmo_lang.object.pseudo.MC_EACH;
import org.jmo_lang.object.pseudo.MC_JMO;
import org.jmo_lang.object.pseudo.MC_STREAM;
import org.jmo_lang.object.pseudo.MC_THIS;
import org.jmo_lang.object.pseudo.MagicConst;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;

public class ParseObj_MagicConst
implements I_ParseObject {
    private static final String regex = "^(_[A-Z]*)(.*)?$";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '_';
    }

    @Override
    public Group2<I_Object, String> parse(App app, Block current, String s, DebugInfo debugInfo) {
        Err.ifNull(current);
        String var = s.replaceFirst(regex, "$1");
        String rem = s.substring(var.length());
        switch (var) {
            case "_THIS": {
                return this.res(new MC_THIS(current.gType()), rem);
            }
            case "_ITS": 
            case "_STREAM": {
                return this.res(new MC_STREAM(), rem);
            }
            case "_ITE": 
            case "_EACH": {
                return this.res(new MC_EACH(), rem);
            }
            case "_BLOCK": 
            case "_IT": 
            case "_ITB": {
                return this.res(new MC_BLOCK(), rem);
            }
            case "_FUNC": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.FUNC), rem);
            }
            case "_LOOP": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.LOOP), rem);
            }
            case "_LINE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.LINE), rem);
            }
            case "_FILE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.FILE), rem);
            }
            case "_ARGS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.ARGS), rem);
            }
            case "_APP": {
                return this.res(app, rem);
            }
            case "_JMO": {
                return this.res(new MC_JMO(), rem);
            }
            case "_PI": {
                return this.res(new Dec(Math.PI), rem);
            }
            case "_E": {
                return this.res(new Dec(Math.E), rem);
            }
            case "_DEBUG": {
                return this.res(new MC_DEBUG(), rem);
            }
        }
        throw new ParseError("Unknown MagicConst", "Got: " + var, debugInfo);
    }

    private Group2<I_Object, String> res(I_Object result, String rem) {
        return new Group2<I_Object, String>(result, rem);
    }
}

