/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.filter.FilterText;
import java.util.regex.Matcher;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Block;
import org.jmo_lang.struct.App;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.LineBuffer;

public class Parser_Script {
    private final LineBuffer buffer;
    private final App app;

    public Parser_Script(App app, String filename, String text) {
        String[] lines = text.split(System.getProperty("line.separator"));
        this.iFilterLines(lines, filename);
        this.iCombineLines(lines);
        this.buffer = new LineBuffer(filename, lines);
        this.app = app;
    }

    public void parse() {
        Parser_Block parserBlock = new Parser_Block();
        parserBlock.parse(this.app, this.app.getRootType(), null, this.app.getRootType().getBlock(), this.buffer, true);
    }

    private void iCombineLines(String[] lines) {
        int max;
        int unten = max = lines.length - 1;
        while (unten >= 1) {
            if (lines[unten] != null) {
                int depth2;
                int depth1;
                String uTrim;
                int oben = unten - 1;
                while (oben >= 0 && lines[oben] == null) {
                    --oben;
                }
                if (oben < 0 || oben == 0 && lines[0] == null) break;
                if (lines[oben].trim().endsWith(",")) {
                    int n = oben;
                    lines[n] = String.valueOf(lines[n]) + lines[unten].trim();
                    lines[unten] = null;
                }
                if ((uTrim = lines[unten].trim()).length() > 0 && "\\+\\*/.\\],".indexOf(uTrim.charAt(0)) >= 0 && (depth1 = Lib_Parser.getDepth(lines[unten])) == (depth2 = Lib_Parser.getDepth(lines[oben]))) {
                    int n = oben;
                    lines[n] = String.valueOf(lines[n]) + lines[unten].trim();
                    lines[unten] = null;
                }
            }
            --unten;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void iFilterLines(String[] lines, String filename) {
        block_comment = false;
        ignore = false;
        textblock = null;
        i = 0;
        while (i < lines.length) {
            s = lines[i];
            if (!block_comment) ** GOTO lbl14
            idx = s.indexOf("*/");
            if (idx < 0) {
                lines[i] = null;
            } else {
                lines[i] = s.substring(idx + 2);
                block_comment = false;
lbl14:
                // 2 sources

                if (textblock != null) {
                    if (s.startsWith("\"\"\"\"")) {
                        textblock.deleteCharAt(textblock.length() - 1);
                        tb = textblock.toString();
                        tb = FilterText.replace("\\", Matcher.quoteReplacement("\\\\"), tb);
                        tb = FilterText.replace("\"", Matcher.quoteReplacement("\\\""), tb);
                        lines[i] = "\"" + tb.toString() + s.substring(3);
                        textblock = null;
                    } else {
                        textblock.append(String.valueOf(s) + '\n');
                        lines[i] = null;
                    }
                } else {
                    sTrim = s.trim();
                    if (sTrim.startsWith("/*")) {
                        idx = s.indexOf("*/", 2);
                        if (idx >= 0) {
                            lines[i] = s.substring(idx + 2);
                        } else {
                            lines[i] = null;
                            block_comment = true;
                        }
                    } else if (s.startsWith("\"\"\"\"") && sTrim.length() == 4) {
                        textblock = new StringBuilder();
                        lines[i] = null;
                    } else {
                        if (ignore || s.startsWith("#**#")) {
                            lines[i] = null;
                            ignore = true;
                        }
                        if (sTrim.length() == 0 || sTrim.charAt(0) == '#') {
                            lines[i] = null;
                        } else if (s.startsWith(" ")) {
                            throw new ParseError("Line starts with Space-Char(s)", s, new DebugInfo(filename, i + 1));
                        }
                    }
                }
            }
            ++i;
        }
    }
}

