/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.list;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_StrFormat;

public class JMo_List
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList {
    private ArrayList<I_Object> list;
    private Call[] init;
    private boolean fixedLength = false;
    private boolean fixedTypes = false;

    public JMo_List() {
        this.list = new ArrayList();
        this.init = null;
    }

    public JMo_List(ArrayList<I_Object> list) {
        this.list = list;
        this.init = null;
    }

    public JMo_List(Call ... ca) {
        this.list = null;
        this.init = ca;
    }

    @Override
    public void init(CurProc cp) {
        if (this.init != null) {
            this.list = new ArrayList();
            Call[] callArray = this.init;
            int n = this.init.length;
            int n2 = 0;
            while (n2 < n) {
                Call ca = callArray[n2];
                I_Object o = ca.exec(cp, null);
                o = Lib_Convert.getValue(cp, o);
                this.list.add(o);
                ++n2;
            }
            this.init = null;
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "+": 
            case "add": 
            case "join": {
                return JMo_List.stdResult(this.add(cp));
            }
            case "delete": 
            case "-": {
                return JMo_List.stdResult(this.removePos(cp));
            }
            case "remove": 
            case "--": {
                return JMo_List.stdResult(this.removeItems(cp));
            }
            case "insert": {
                return JMo_List.stdResult(this.insert(cp));
            }
            case "clear": {
                return JMo_List.stdResult(this.clear(cp));
            }
            case "swap": {
                return JMo_List.stdResult(this.swap(cp));
            }
            case "concat": 
            case "++": {
                return JMo_List.stdResult(this.concat(cp));
            }
            case "shuffle": {
                return JMo_List.stdResult(this.shuffle(cp));
            }
            case "reverse": {
                return JMo_List.stdResult(this.reverse(cp));
            }
            case "uniq": {
                return JMo_List.stdResult(this.uniq(cp));
            }
            case "copy": {
                return JMo_List.stdResult(this.copy(cp));
            }
            case "first": {
                return JMo_List.stdResult(this.first(cp));
            }
            case "last": {
                return JMo_List.stdResult(this.last(cp));
            }
            case "length": 
            case "len": 
            case "size": {
                return JMo_List.stdResult(this.size(cp));
            }
            case "get": {
                return JMo_List.stdResult(this.get(cp));
            }
            case "set": {
                return JMo_List.stdResult(this.set(cp));
            }
            case "only": {
                return JMo_List.stdResult(this.only(cp));
            }
            case "has": 
            case "knows": {
                return JMo_List.stdResult(this.knows(cp));
            }
            case "each": {
                return this.each(cp);
            }
            case "eachVertical": {
                return this.eachVertical(cp);
            }
            case "isEmpty": {
                return JMo_List.stdResult(this.isEmpty(cp));
            }
            case "combine": 
            case "implode": {
                return JMo_List.stdResult(this.implode(cp));
            }
            case "unfold": {
                return JMo_List.stdResult(this.unfold(cp));
            }
            case "format": {
                return JMo_List.stdResult(this.format(cp));
            }
            case "min": {
                return JMo_List.stdResult(this.min(cp));
            }
            case "max": {
                return JMo_List.stdResult(this.max(cp));
            }
            case "sum": {
                return JMo_List.stdResult(this.sum(cp));
            }
            case "average": 
            case "avg": {
                return JMo_List.stdResult(this.average(cp));
            }
            case "cut": {
                return JMo_List.stdResult(this.cut(cp));
            }
            case "area": {
                return JMo_List.stdResult(this.area(cp));
            }
            case "to": {
                return JMo_List.stdResult(this.to(cp));
            }
            case "left": {
                return JMo_List.stdResult(this.left(cp));
            }
            case "right": {
                return JMo_List.stdResult(this.right(cp));
            }
            case "from": {
                return JMo_List.stdResult(this.from(cp));
            }
            case "filter": {
                return JMo_List.stdResult(this.filter(cp));
            }
            case "map": {
                return JMo_List.stdResult(this.map(cp));
            }
            case "sort": {
                return JMo_List.stdResult(this.sort(cp));
            }
            case "reduce": {
                return JMo_List.stdResult(this.reduce(cp));
            }
            case "fixLength": {
                cp.pars(JMo_List.class, this, new Class[0]);
                this.fixedLength = true;
                return JMo_List.stdResult(this);
            }
            case "fixTypes": {
                cp.pars(JMo_List.class, this, new Class[0]);
                this.fixedTypes = true;
                return JMo_List.stdResult(this);
            }
            case "store": {
                return JMo_List.stdResult(this.store(cp));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CurProc cp) {
        return this.each((CurProc)cp).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CurProc cp) {
        return this.list;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    public ArrayList<I_Object> getInternalObject() {
        return this.list;
    }

    public void internalAdd(I_Object o) {
        if (this.fixedLength) {
            Err.forbidden(o);
        }
        this.list.add(o);
    }

    public Bool knows(CurProc cp) {
        I_Object o = cp.pars(Bool.class, this, I_Object.class)[0];
        for (I_Object lo : this.list) {
            if (lo.compareTo(o) != 0) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public Int size(CurProc cp) {
        cp.pars(Int.class);
        return new Int(this.list.size());
    }

    @Override
    public String toDebug(CurProc cp) {
        return "List(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        String s = this.list == null ? "null" : Lib_Output.toString(this.list, true);
        return "[" + s + "]";
    }

    private JMo_List add(CurProc cp) {
        I_Object[] oa = cp.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        this.iFixed(cp);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_List insert(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_List.class, this, Int.class, null);
        this.iFixed(cp);
        int pos = Lib_Convert.getIntValue(cp, oa[0]);
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), pos);
        this.list.add(pos - 1, oa[1]);
        return this;
    }

    private JMo_List area(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_List.class, this, Int.class, Int.class);
        int start = ((Int)oa[0]).gValue();
        int end = ((Int)oa[1]).gValue();
        int size = this.list.size();
        Lib_Error.ifEmpty(cp, this.list.size(), "List");
        Lib_Error.ifNotBetween(cp, 1, Math.min(end, size), start);
        Lib_Error.ifNotBetween(cp, Math.max(1, start), size, end);
        return this.iCutCopy(cp, start, Math.min(this.list.size(), end));
    }

    private JMo_List concat(CurProc cp) {
        JMo_List list2 = (JMo_List)cp.pars(JMo_List.class, this, JMo_List.class)[0];
        this.iFixed(cp);
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        newList.addAll(this.list);
        newList.addAll(list2.getInternalObject());
        return new JMo_List(newList);
    }

    private JMo_List copy(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        ArrayList copy = (ArrayList)this.list.clone();
        return new JMo_List(copy);
    }

    private JMo_List cut(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_List.class, this, Int.class, Int.class);
        int start = ((Int)oa[0]).gValue();
        int len = ((Int)oa[1]).gValue();
        Lib_Error.ifEmpty(cp, this.list.size(), "List");
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), start);
        if (len == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (len > this.list.size()) {
            len = this.list.size() - start + 1;
        }
        return this.iCutCopy(cp, start, Math.min(this.list.size(), start + len - 1));
    }

    private Result_Obj each(CurProc cpOld) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        CurProc cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        for (I_Object it : this.list) {
            result = Lib_Exec.execBlock(cpNew, args, it);
            if (!((result = Lib_Exec.loopResult(result)) instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new Result_Obj(result, true);
    }

    private Result_Obj eachVertical(CurProc cpOld) {
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        if (cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'eachAll'", null);
        }
        CurProc cpNew = cpOld.copyLoop(new Handle_Loop(this));
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = this;
        int maxItems = 1;
        int pos = 1;
        while (pos <= maxItems) {
            ArrayList<I_Object> cur_al = new ArrayList<I_Object>();
            for (I_Object item : this.list) {
                if ((item = Lib_Convert.getValue(cpNew, item)) instanceof I_AutoBlockList) {
                    ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cpNew.copyNil());
                    int len = abl.size();
                    if (len > maxItems) {
                        maxItems = len;
                    }
                    Nil o = len >= pos ? abl.get(pos - 1) : Nil.NIL;
                    cur_al.add(o);
                    continue;
                }
                cur_al.add(pos == 1 ? item : Nil.NIL);
            }
            JMo_List cur = new JMo_List(cur_al);
            result = Lib_Exec.execBlock(cpNew, args, cur);
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++pos;
        }
        return new Result_Obj(result, true);
    }

    private JMo_List filter(CurProc cp) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Call c = new Call(cp.getSurrBlock(), null, cp.getMethod(), cp.call.getInternPars(), cp.getDebugInfo());
            Bool ok = (Bool)cp.copyCall(c, false).parsEach(JMo_List.class, this, new I_Object[]{test}, Bool.class)[0];
            if (ok.gValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List map(CurProc cp) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Call c = new Call(cp.getSurrBlock(), null, cp.getMethod(), cp.call.getInternPars(), cp.getDebugInfo());
            I_Object[] test2 = new I_Object[]{test};
            I_Object testr = cp.copyCall(c, false).parsEach(JMo_List.class, this, test2, I_Object.class)[0];
            result.add(testr);
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object reduce(CurProc cp) {
        I_Object sum = cp.parsOneAdvance(null, this, 0, I_Object.class);
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] test2 = new I_Object[]{sum, test};
            Call c = new Call(cp.getSurrBlock(), null, cp.getMethod(), cp.call.getInternPars(), cp.getDebugInfo());
            sum = cp.copyCall(c, false).parsEach(JMo_List.class, this, test2, I_Object.class, I_Object.class)[1];
            ++p;
        }
        return sum;
    }

    private JMo_List unfold(CurProc cp) {
        cp.pars(JMo_List.class);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Object item : this.list) {
            if (item instanceof I_AutoBlockList) {
                ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cp.copyNil());
                for (I_Object o : abl) {
                    result.add(o);
                }
                continue;
            }
            result.add(item);
        }
        return new JMo_List(result);
    }

    private I_Object first(CurProc cp) {
        cp.pars(null);
        return this.list.size() == 0 ? Nil.NIL : this.list.get(0);
    }

    private JMo_List from(CurProc cp) {
        I_Object o = cp.pars(JMo_List.class, this, Int.class)[0];
        int par = ((Int)o).gValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cp, 1, size, par);
        return this.iCutCopy(cp, par, size);
    }

    private I_Object get(CurProc cp) {
        I_Object[] oa = cp.parsFlex(null, this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            Int oi = (Int)cp.parType(oa[0], Int.class);
            int i = oi.gValue();
            if (i < 1 || i > this.list.size()) {
                throw new ExecError(cp, "Index out of bounds", "Size = " + this.list.size() + ", can't get element: " + i);
            }
            return this.list.get(i - 1);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            Int oi = (Int)cp.parType(o, Int.class);
            int i = oi.gValue();
            if (i < 1 || i > this.list.size()) {
                throw new ExecError(cp, "Index out of bounds", "Size = " + this.list.size() + ", can't get element: " + i);
            }
            I_Object g = this.list.get(i - 1);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private Str implode(CurProc cp) {
        I_Object[] pars = cp.parsFlex(Str.class, this, 0, 1);
        if (pars.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.list) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_AtomicValue atomic = (I_AtomicValue)cp.parType(pars[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cp, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.list.size()) {
            I_Object o = this.list.get(i);
            String s = Lib_Convert.getStringValue(cp, o);
            sb.append(s);
            if (i != this.list.size() - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    private Bool isEmpty(CurProc cp) {
        cp.pars(Bool.class);
        return Bool.getObject(this.list.size() == 0);
    }

    private I_Object last(CurProc cp) {
        cp.pars(null);
        int len = this.list.size();
        return len == 0 ? Nil.NIL : this.list.get(len - 1);
    }

    private JMo_List left(CurProc cp) {
        I_Object o = cp.pars(JMo_List.class, this, Int.class)[0];
        int left = ((Int)o).gValue();
        Lib_Error.ifTooLow(cp, 0, left);
        if (left == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (left > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cp, 1, Math.min(left, this.list.size()));
    }

    private I_Object max(CurProc cp) {
        cp.pars(null);
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cp, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object min(CurProc cp) {
        cp.pars(null);
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cp, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object average(CurProc cp) {
        cp.pars(Dec.class);
        double result = 0.0;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cp, o);
            result += d / (double)this.list.size();
        }
        return new Dec(result);
    }

    private I_Object sum(CurProc cp) {
        cp.pars(Dec.class);
        double result = 0.0;
        for (I_Object o : this.list) {
            result += Lib_Convert.getDoubleValue(cp, o);
        }
        return new Dec(result);
    }

    private JMo_List only(CurProc cp) {
        I_Object[] pars = cp.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] i_ObjectArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                String teststr;
                I_Object par = i_ObjectArray[n2];
                if (par instanceof JMo_Regex) {
                    JMo_Regex regex = (JMo_Regex)par;
                    teststr = Lib_Convert.getStringValue(cp, test);
                    if (teststr.matches(regex.toString())) {
                        result.add(test);
                    }
                } else if (par instanceof Str) {
                    String search = Lib_Convert.getStringValue(cp, par);
                    teststr = Lib_Convert.getStringValue(cp, test);
                    if (teststr.equals(search)) {
                        result.add(test);
                    }
                } else if (test.compareTo(par) == 0) {
                    result.add(test);
                }
                ++n2;
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List removeItems(CurProc cp) {
        I_Object[] oa = cp.parsFlex(JMo_List.class, this, 1, Integer.MAX_VALUE);
        this.iFixed(cp);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).equals(o)) {
                    this.list.remove(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_List removePos(CurProc cp) {
        Int o = (Int)cp.pars(JMo_List.class, this, Int.class)[0];
        this.iFixed(cp);
        int oi = Lib_Convert.getIntValue(cp, o);
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), oi);
        this.list.remove(oi - 1);
        return this;
    }

    private JMo_List clear(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        this.iFixed(cp);
        this.list.clear();
        return this;
    }

    private JMo_List swap(CurProc cp) {
        I_Object[] pars = cp.pars(JMo_List.class, this, A_IntNumber.class, A_IntNumber.class);
        this.iFixed(cp);
        int pos1 = Lib_Convert.getIntValue(cp, pars[0]);
        int pos2 = Lib_Convert.getIntValue(cp, pars[1]);
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), pos1);
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), pos2);
        I_Object buffer = this.list.get(--pos1);
        this.list.set(pos1, this.list.get(--pos2));
        this.list.set(pos2, buffer);
        return this;
    }

    private JMo_List reverse(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            dest.add(0, o);
        }
        this.list = dest;
        return this;
    }

    private JMo_List right(CurProc cp) {
        I_Object o = cp.pars(JMo_List.class, this, Int.class)[0];
        int right = ((Int)o).gValue();
        Lib_Error.ifTooLow(cp, 0, right);
        if (right == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (right > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cp, Math.max(1, this.list.size() - right + 1), this.list.size());
    }

    private JMo_List set(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_List.class, this, Int.class, null);
        int i = Lib_Convert.getIntValue(cp, oa[0]);
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), i);
        I_Object o = oa[1];
        if (this.fixedTypes) {
            Class<?> t = o.getClass();
            I_Object curo = this.list.get(i);
            Class<?> curt = curo.getClass();
            if (t != Nil.class && !curt.isAssignableFrom(t)) {
                throw new ExecError(cp, "Wrong Type for List-Position!", "(" + Lib_Convert.typeName(curt, curo) + ") <-- (" + Lib_Convert.typeName(t, o) + ") " + o);
            }
        }
        this.list.set(i - 1, o);
        return this;
    }

    private JMo_List shuffle(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        int[] rnd = Lib_Random.getIntArraySet(0, this.list.size() - 1);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        int[] nArray = rnd;
        int n = rnd.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            dest.add(this.list.get(i));
            ++n2;
        }
        this.list = dest;
        return this;
    }

    private JMo_List sort(CurProc cp) {
        int parCount = cp.parCount();
        if (parCount == 0) {
            cp.pars(JMo_List.class);
            this.list.sort(null);
            return this;
        }
        int l = 1;
        while (l < this.list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= this.list.size()) {
                I_Object buffer1 = this.list.get(smallest - 1);
                I_Object buffer2 = this.list.get(m - 1);
                I_Object[] test = new I_Object[]{buffer1, buffer2};
                Call c = new Call(cp.getSurrBlock(), null, cp.getMethod(), cp.call.getInternPars(), cp.getDebugInfo());
                Bool correct = (Bool)cp.copyCall(c, false).parsEach(JMo_List.class, this, test, Bool.class)[0];
                if (!correct.gValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                I_Object buffer1 = this.list.get(pos1);
                I_Object buffer2 = this.list.get(pos2);
                this.list.set(pos1, buffer2);
                this.list.set(pos2, buffer1);
            }
            ++l;
        }
        return this;
    }

    private JMo_List to(CurProc cp) {
        I_Object o = cp.pars(JMo_List.class, this, Int.class)[0];
        int par = ((Int)o).gValue();
        Lib_Error.ifNotBetween(cp, 1, this.list.size(), par);
        return this.iCutCopy(cp, 1, par);
    }

    private JMo_List uniq(CurProc cp) {
        cp.pars(JMo_List.class);
        int p = 0;
        while (p < this.list.size() - 1) {
            I_Object search = this.list.get(p);
            int q = this.list.size() - 1;
            while (q > p) {
                if (this.list.get(q).equals(search)) {
                    this.list.remove(q);
                }
                --q;
            }
            ++p;
        }
        return this;
    }

    private JMo_List store(CurProc cp) {
        I_Object[] pars = cp.call.getPars(cp, this, null);
        if (pars.length != this.list.size()) {
            throw new CodeError(cp, "Wrong Parameter-Count", "Got " + pars.length + ", need equal to listsize: " + this.list.size());
        }
        int pi = 0;
        while (pi < this.list.size()) {
            I_Object par = cp.parTypeExt(pars[pi], VarLet.class, Nil.class);
            if (!(par instanceof Nil)) {
                Var v = ((VarLet)par).getVar();
                v.set(cp, cp, this.list.get(pi));
            }
            ++pi;
        }
        return this;
    }

    private Str format(CurProc cp) {
        String form = ((Str)cp.pars(Str.class, this, Str.class)[0]).gValue();
        int listPos = 0;
        int formPos = 0;
        StringBuilder sb = new StringBuilder();
        while (formPos < form.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(form, formPos);
            formPos += part.g2().length();
            if (!part.g1().booleanValue() || listPos >= this.list.size()) {
                sb.append(part.g2());
                continue;
            }
            sb.append(Lib_StrFormat.format(cp, part.g2(), this.list.get(listPos++)));
        }
        return new Str(sb.toString());
    }

    private JMo_List iCutCopy(CurProc cp, int start, int end) {
        Lib_Error.ifTooLow(cp, start, end);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = start - 1;
        while (i < end) {
            result.add(this.list.get(i));
            ++i;
        }
        return new JMo_List(result);
    }

    private void iFixed(CurProc cp) {
        if (this.fixedLength) {
            throw new CodeError(cp, "Can't change size of fixed List", "Adding/Removing elements is not allowed!");
        }
    }
}

