/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public abstract class A_Number
extends A_Atomic {
    @Override
    public final Result_Obj call3(CurProc cp, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Number.stdResult(this.ar(cp, NOP1.ADD, true));
            }
            case "-": 
            case "sub": {
                return A_Number.stdResult(this.ar(cp, NOP1.SUB, new boolean[0]));
            }
            case "*": 
            case "mul": {
                return A_Number.stdResult(this.ar(cp, NOP1.MUL, true));
            }
            case "/": 
            case "div": {
                return A_Number.stdResult(this.ar(cp, NOP1.DIV, new boolean[0]));
            }
            case "%": 
            case "mod": {
                return A_Number.stdResult(this.ar(cp, NOP1.MOD, new boolean[0]));
            }
            case "log": {
                return A_Number.stdResult(this.ar(cp, NOP1.LOG, new boolean[0]));
            }
            case "logRound": {
                return A_Number.stdResult(this.ar(cp, NOP1.LOGR, new boolean[0]));
            }
            case "&": 
            case "and": {
                return A_Number.stdResult(this.ar(cp, NOP1.AND, new boolean[0]));
            }
            case "|": 
            case "or": {
                return A_Number.stdResult(this.ar(cp, NOP1.OR, new boolean[0]));
            }
            case "^": 
            case "xor": {
                return A_Number.stdResult(this.ar(cp, NOP1.XOR, new boolean[0]));
            }
            case "<<": 
            case "shiftLeft": {
                return A_Number.stdResult(this.ar(cp, NOP1.SHL, new boolean[0]));
            }
            case ">>": 
            case "shiftRight": {
                return A_Number.stdResult(this.ar(cp, NOP1.SHR, new boolean[0]));
            }
            case "++": 
            case "inc": {
                return A_Number.stdResult(this.ar(cp, NOP0.INC));
            }
            case "--": 
            case "dec": {
                return A_Number.stdResult(this.ar(cp, NOP0.DEC));
            }
            case "~": 
            case "neg": {
                return A_Number.stdResult(this.ar(cp, NOP0.NEG));
            }
            case "abs": {
                return A_Number.stdResult(this.ar(cp, NOP0.ABS));
            }
            case "**": 
            case "pow": {
                return A_Number.stdResult(this.ar(cp, NOP01.POW));
            }
            case "//": 
            case "sqrt": {
                return A_Number.stdResult(this.ar(cp, NOP01.SQR));
            }
            case "format": {
                return A_Number.stdResult(this.format(cp));
            }
            case "limit": {
                return A_Number.stdResult(this.limit(cp));
            }
        }
        return this.call4(cp, method);
    }

    public abstract Result_Obj call4(CurProc var1, String var2);

    @Override
    public boolean equals(Object o) {
        if (o instanceof I_AtomicValue) {
            return ((A_Number)o).gValue().equals(this.gValue());
        }
        return super.equals(o);
    }

    protected abstract A_Number number_op(CurProc var1, NOP0 var2);

    protected abstract A_Number number_op(CurProc var1, NOP01 var2, I_Object[] var3);

    protected abstract A_Number number_op(CurProc var1, NOP1 var2, A_Number var3);

    protected abstract I_AtomicValue number_opStr(CurProc var1, NOP1 var2, A_Atomic var3);

    private I_AtomicValue ar(CurProc cp, NOP0 op) {
        cp.pars(this.getClass());
        return this.number_op(cp, op);
    }

    private I_AtomicValue ar(CurProc cp, NOP01 op) {
        I_Object[] pars = cp.parsFlex(null, this, 0, 1);
        return this.number_op(cp, op, pars);
    }

    private I_AtomicValue ar(CurProc cp, NOP1 op, boolean ... strPossible) {
        if (strPossible.length > 0 && strPossible[0]) {
            A_Atomic para = (A_Atomic)cp.pars(this.getClass(), this, A_Atomic.class)[0];
            if (para instanceof A_Number) {
                return this.number_op(cp, op, (A_Number)para);
            }
            if (para instanceof Bool) {
                return this.number_op(cp, op, new Int(Lib_Convert.getIntValue(cp, para)));
            }
            return this.number_opStr(cp, op, para);
        }
        A_Number parn = (A_Number)cp.pars(null, this, A_Number.class)[0];
        return this.number_op(cp, op, parn);
    }

    private Str format(CurProc cp) {
        Str o = (Str)cp.pars(Str.class, this, Str.class)[0];
        String format = o.gValue();
        String number = this.gValue().toString();
        String result = "";
        int nPos = number.length() - 1;
        int fPos = format.length() - 1;
        while (fPos >= 0) {
            char f = format.charAt(fPos);
            if (f == '0') {
                result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : "0" + result;
                --nPos;
            } else if (f == '#') {
                result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : " " + result;
                --nPos;
            } else if (f == '?') {
                if (nPos >= 0) {
                    result = String.valueOf(number.charAt(nPos)) + result;
                }
                --nPos;
            } else {
                result = String.valueOf(f) + result;
            }
            --fPos;
        }
        if (nPos >= 0) {
            result = String.valueOf(number.substring(0, nPos + 1)) + result;
        }
        return new Str(result);
    }

    private A_Number limit(CurProc cp) {
        double max;
        Class[] classArray = new Class[]{A_Number.class, A_Number.class};
        I_Object[] pars = cp.pars(null, this, classArray);
        double min = Lib_Convert.getDoubleValue(cp, pars[0]);
        if (min > (max = Lib_Convert.getDoubleValue(cp, pars[1]))) {
            throw new ExecError(cp, "Min. is greater than max.!", "Min.: " + min + "  Max.: " + max);
        }
        double d = ((Number)this.gValue()).doubleValue();
        if (d > max) {
            d = max;
        }
        if (d < min) {
            d = min;
        }
        return (A_Number)Lib_AtomConv.convert(cp, this.getClass(), (I_Object)new Dec(d));
    }

    protected static enum NOP0 {
        INC,
        DEC,
        NEG,
        ABS;

    }

    protected static enum NOP01 {
        POW,
        SQR;

    }

    protected static enum NOP1 {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        LOG,
        LOGR,
        AND,
        OR,
        XOR,
        SHL,
        SHR;

    }
}

