/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type;

import de.mn77.base.error.Err;
import java.lang.reflect.Constructor;

public class Lib_Class {
    public static String getName(Object o) {
        if (o == null) {
            return "null";
        }
        return Lib_Class.getName(o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getName(Class<?> k) {
        return k.getSimpleName();
    }

    public static <T> T newInstance(Class<T> type, Object ... args) {
        Constructor<?>[] cs;
        Err.ifNull(type, args);
        Constructor<?>[] constructorArray = cs = type.getConstructors();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] cpars = c.getParameterTypes();
            if (cpars.length == args.length) {
                boolean ok = true;
                int i = 0;
                while (i < cpars.length) {
                    if (!cpars[i].isInstance(args[i])) {
                        ok = false;
                        break;
                    }
                    ++i;
                }
                if (ok) {
                    try {
                        return (T)c.newInstance(args);
                    }
                    catch (Exception e) {
                        throw Err.show(e, true, "Can't create the Instance!");
                    }
                }
            }
            ++n2;
        }
        throw Err.invalid("No constructor found", type, args, type.getConstructors());
    }

    public static boolean isHeir(Object obj, Class<?> ofClass) {
        return ofClass.isAssignableFrom(obj.getClass());
    }

    public static boolean isHeir(Class<?> objclass, Class<?> ofClass) {
        return ofClass.isAssignableFrom(objclass);
    }
}

