/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import java.util.ArrayList;

public class ConvText {
    public static String[] csvLineToString(String line, char delimiter_field, char delimiter_col) {
        ArrayList<String> result = new ArrayList<String>();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        int p = 0;
        while (p < line.length()) {
            boolean last;
            char c = line.charAt(p);
            boolean bl = last = p == line.length() - 1;
            if (c == delimiter_field) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (last || line.charAt(p + 1) != delimiter_field) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                }
            } else if (!open && c == delimiter_col) {
                result.add(field);
                field = "";
                if (last) {
                    result.add("");
                }
            } else {
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (field.length() > 0) {
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    public static Integer toInteger(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Boolean toBoolean(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TypeTable2<String, Boolean> splitToTable(String s, String ... delimiter) {
        TypeTable2<String, Boolean> result = new TypeTable2<String, Boolean>(String.class, Boolean.class);
        TypeTable2<Integer, String> tab = SearchText.positionsMulti(s, delimiter);
        int tz = 1;
        while (tz <= tab.size()) {
            int start = (Integer)tab.getCol1().get(tz);
            String delim = (String)tab.getCol2().get(tz);
            if (tz == 1 && start > 1) {
                result.add(FilterText.cut(1, start - 1, s), false);
            }
            int bis = tz < tab.size() ? (Integer)tab.getCol1().get(tz + 1) - 1 : s.length();
            int fromText = start + delim.length();
            result.add(delim, true);
            if (fromText <= bis) {
                result.add(FilterText.cut(fromText, bis - fromText + 1, s), false);
            }
            ++tz;
        }
        if (tab.size() == 0 && s.length() > 0) {
            result.add(s, false);
        }
        return result;
    }

    public static <T> T toObject(String s, Class<T> c) {
        if (s == null) {
            return null;
        }
        Err.ifNull(c);
        if (c == String.class) {
            return (T)s;
        }
        if (c == Integer.class) {
            return (T)Integer.valueOf(Integer.parseInt(s));
        }
        if (c == I_Date.class) {
            return (T)new MDate(s);
        }
        if (c == Boolean.class) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(s));
        }
        if (c == I_DateTime.class) {
            return (T)new MDateTime(s);
        }
        throw Err.todo("Unknown Class to convert", s, c);
    }

    public static I_List<String> toList(String delimiter, String s) {
        Err.ifEmpty(delimiter);
        Err.ifNull(s);
        MList<String> result = new MList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 1;
        if (s.indexOf(delimiter) == 0) {
            result.add("");
        } else {
            start -= delimiter.length();
        }
        while (start <= s.length()) {
            int nt = s.indexOf(delimiter, (start += delimiter.length()) - 1) + 1;
            if (nt < 1) {
                nt = s.length() + 1;
            }
            if (start > s.length()) {
                result.add("");
            } else {
                result.add(FilterText.cut(start, nt - start, s));
            }
            start += nt - start;
        }
        return result;
    }

    public static String[] toStringArray(String delimiter, String s) {
        I_List<String> c = ConvText.toList(delimiter, s);
        return c.toArray((String[])new String[c.size()]);
    }
}

