/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.PARSER_LEVEL;
import org.jmo_lang.parser.ParseManagerFunc;
import org.jmo_lang.parser.ParseManagerObj;
import org.jmo_lang.struct.runtime.CurProc;

public class StrictManager {
    private final ParseManagerObj parsemanager_obj;
    private final ParseManagerFunc parsemanager_func;
    private boolean strictAutoBlock = false;
    private boolean strictAutoBlockAfterFunc = false;
    private boolean strictFuncParType = false;
    private boolean strictFuncResultType = false;
    private boolean strictSave = false;
    private boolean strictAnotherScript = false;
    private PARSER_LEVEL parserLevel = PARSER_LEVEL.OPEN;

    public StrictManager(ParseManagerObj parsemanager_obj, ParseManagerFunc parsemanager_func) {
        this.parsemanager_obj = parsemanager_obj;
        this.parsemanager_func = parsemanager_func;
    }

    public void set(PARSER_LEVEL level, DebugInfo debug) {
        if (this.parserLevel != PARSER_LEVEL.OPEN && level != this.parserLevel) {
            throw new ParseError("Parser-Level already set!", level.name().toLowerCase(), debug);
        }
        this.parserLevel = level;
        this.parsemanager_obj.strictLevel(level);
        this.parsemanager_func.strictLevel(level);
        switch (level) {
            case VERYSTRICT: 
            case INSANE: {
                this.strictAutoBlock = true;
                this.strictFuncResultType = true;
            }
            case STRICT: {
                this.strictAutoBlockAfterFunc = true;
                this.strictFuncParType = true;
            }
        }
    }

    public void setSave() {
        this.strictSave = true;
        this.parsemanager_obj.strictSave();
        this.parsemanager_func.strictSave();
    }

    public void setAnotherScript() {
        this.strictAnotherScript = true;
    }

    public void checkSave(CurProc cp, String of) {
        if (this.strictSave) {
            throw new CodeError(cp, "Strict! This object/function is forbidden!", of);
        }
    }

    public void checkSave(DebugInfo debug, String of) {
        if (this.strictSave) {
            throw new ParseError("Strict! This object/function is forbidden!", of, debug);
        }
    }

    public void checkAutoBlock(CurProc cp) {
        if (this.strictAutoBlock) {
            throw new CodeError(cp, "Strict! Auto-Block-Function and .do are forbidden!", "Use it with the correct function, for example '.each'");
        }
    }

    public void checkAutoBlockAfterFunc(CurProc cp) {
        if (this.strictAutoBlockAfterFunc) {
            throw new CodeError(cp, "Strict! Auto-Block-Function after a Function is forbidden!", "Use the correct function, for example '.each'");
        }
    }

    public void checkFuncParType(String pType, String pName, DebugInfo debug) {
        if (this.strictFuncParType && pType == null) {
            throw new ParseError("Strict! Missing type of parameter!", pName, debug);
        }
    }

    public void checkFuncResultType(String fType, String fName, DebugInfo debug) {
        if (this.strictFuncResultType && fType == null) {
            throw new ParseError("Strict! Missing result-type of function!", fName, debug);
        }
    }

    public void checkGroupIf(CurProc cp) {
        if (this.parserLevel.ordinal() >= PARSER_LEVEL.STRICT.ordinal()) {
            throw new CodeError(cp, "Strict! Auto-Block-Function for Group is forbidden!", "Use If()");
        }
    }

    public void checkParseTimeSwitch(String s, DebugInfo debug) {
        if (this.strictAnotherScript) {
            throw new ParseError("Strict! This command is invalid or only allowed at the top of the first files!", s, debug);
        }
        if (this.strictSave) {
            throw new ParseError("Strict! All parse-time-commands are forbidden!", s, debug);
        }
    }
}

