/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.list;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.list.JMo_MapItem;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Map
extends A_Object
implements I_AutoBlockDo {
    private final ArrayList<I_Object> keys;
    private final ArrayList<I_Object> objects;

    public JMo_Map() {
        this.keys = new ArrayList();
        this.objects = new ArrayList();
    }

    public JMo_Map(ArrayList<I_Object> keys, ArrayList<I_Object> objects) {
        this.keys = keys;
        this.objects = objects;
    }

    @Override
    public void init(CurProc cp) {
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "add": {
                return JMo_Map.stdResult(this.add(cp));
            }
            case "remove": 
            case "sub": {
                return JMo_Map.stdResult(this.remove(cp));
            }
            case "clear": {
                return JMo_Map.stdResult(this.clear(cp));
            }
            case "copy": {
                return JMo_Map.stdResult(this.copy(cp));
            }
            case "length": 
            case "len": 
            case "size": {
                return JMo_Map.stdResult(this.size(cp));
            }
            case "get": {
                return JMo_Map.stdResult(this.get(cp));
            }
            case "set": {
                return JMo_Map.stdResult(this.set(cp));
            }
            case "isEmpty": {
                return JMo_Map.stdResult(this.isEmpty(cp));
            }
            case "keys": {
                return JMo_Map.stdResult(this.getKeys(cp));
            }
            case "objects": {
                return JMo_Map.stdResult(this.getObjects(cp));
            }
            case "hasKey": 
            case "knowsKey": {
                return JMo_Map.stdResult(this.knowsKey(cp));
            }
            case "hasObject": 
            case "knowsObject": {
                return JMo_Map.stdResult(this.knowsObject(cp));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CurProc cp) {
        return this.each((CurProc)cp).obj;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    public I_Table<I_Object> internalTable() {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int i = 0;
        while (i < this.keys.size()) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.objects.get(i)});
            ++i;
        }
        return tab;
    }

    private Result_Obj each(CurProc cpOld) {
        JMo_MapItem item;
        boolean varlet;
        I_Object[] pars = cpOld.parsBlockFlex(this, 0, 1);
        boolean bl = varlet = pars.length == 1;
        if (varlet) {
            cpOld.parType(pars[0], VarLet.class);
        }
        Call stream = cpOld.getStream();
        Block block = cpOld.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cpOld, "No Stream or Block for 'each'", null);
        }
        CurProc cpNew = cpOld.copyLoop(new Handle_Loop(this));
        I_Object res = this;
        int pos = 0;
        while (pos < this.keys.size()) {
            block13: {
                item = new JMo_MapItem(this.keys.get(pos), this.objects.get(pos));
                if (varlet) {
                    Var o = ((VarLet)pars[0]).getVar();
                    o.set(cpNew, cpNew, item);
                }
                if (block != null) {
                    try {
                        res = block.exec(cpNew, item);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        switch (temp.getLevel()) {
                            case CONTINUE: {
                                break block13;
                            }
                            default: {
                                return temp.getLoopResult();
                            }
                        }
                    }
                }
                if (stream != null && block == null) {
                    res = stream.exec(cpNew, item);
                }
            }
            ++pos;
        }
        if (stream != null && block != null) {
            if (this.keys.size() == 0) {
                Err.todo("Map is empty!");
            }
            int last = this.keys.size() - 1;
            item = new JMo_MapItem(this.keys.get(last), this.objects.get(last));
            res = stream.exec(cpNew, item);
        }
        return new Result_Obj(res, true);
    }

    public Int size(CurProc cp) {
        cp.pars(Int.class);
        return new Int(this.keys.size());
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Map(");
        int i = 0;
        while (i < this.keys.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.keys.get(i).toString());
            sb.append("=>");
            sb.append(this.objects.get(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private JMo_Map add(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_Map.class, this, I_Object.class, I_Object.class);
        I_Object key = oa[0];
        I_Object object = oa[1];
        int i = this.iGetPosition(cp, key, false);
        if (i != -1) {
            throw new ExecError(cp, "Duplicated Key", "Got: " + key);
        }
        this.keys.add(key);
        this.objects.add(object);
        return this;
    }

    private JMo_Map copy(CurProc cp) {
        cp.pars(JMo_Map.class, this, new Class[0]);
        ArrayList clonek = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.objects.clone();
        return new JMo_Map(clonek, cloneo);
    }

    private I_Object get(CurProc cp) {
        I_Object[] oa = cp.parsFlex(null, this, 1, Integer.MAX_VALUE);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetPosition(cp, key, true);
            return this.objects.get(i);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object key = i_ObjectArray[n2];
            int i = this.iGetPosition(cp, key, true);
            I_Object g = this.objects.get(i);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private JMo_List getKeys(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        ArrayList clone = (ArrayList)this.keys.clone();
        return new JMo_List(clone);
    }

    private JMo_List getObjects(CurProc cp) {
        cp.pars(JMo_List.class, this, new Class[0]);
        ArrayList clone = (ArrayList)this.objects.clone();
        return new JMo_List(clone);
    }

    private int iGetPosition(CurProc cp, I_Object key, boolean error) {
        int i = 0;
        while (i < this.keys.size()) {
            boolean equal = this.keys.get(i).equals(key);
            if (equal) {
                return i;
            }
            ++i;
        }
        if (error) {
            throw new ExecError(cp, "Unknown key", "Got: " + key);
        }
        return -1;
    }

    private Bool isEmpty(CurProc cp) {
        cp.pars(Bool.class);
        return Bool.getObject(this.keys.size() == 0);
    }

    private Bool knowsKey(CurProc cp) {
        I_Object search = cp.pars(Bool.class, this, I_Object.class)[0];
        for (I_Object k : this.keys) {
            if (!k.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private Bool knowsObject(CurProc cp) {
        I_Object search = cp.pars(Bool.class, this, I_Object.class)[0];
        for (I_Object o : this.objects) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_Map remove(CurProc cp) {
        I_Object key = cp.pars(JMo_Map.class, this, I_Object.class)[0];
        int i = this.iGetPosition(cp, key, true);
        this.keys.remove(i);
        this.objects.remove(i);
        return this;
    }

    private JMo_Map clear(CurProc cp) {
        cp.pars(JMo_Map.class, this, new Class[0]);
        this.keys.clear();
        this.objects.clear();
        return this;
    }

    private JMo_Map set(CurProc cp) {
        I_Object[] oa = cp.pars(JMo_Map.class, this, I_Object.class, I_Object.class);
        I_Object key = oa[0];
        I_Object value = oa[1];
        int i = this.iGetPosition(cp, key, true);
        this.objects.set(i, value);
        return this;
    }
}

