/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.error.Err;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class Bool
extends A_Atomic
implements I_Integer,
I_Atomic {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    private final boolean value;

    public static final Bool getObject(boolean b) {
        return b ? TRUE : FALSE;
    }

    private Bool(boolean val) {
        this.value = val;
    }

    @Override
    public Result_Obj call3(CurProc cp, String method) {
        switch (method) {
            case "else": {
                return this.doIf(cp, false, true, false, false);
            }
            case "+": 
            case "add": {
                return Bool.stdResult(this.add(cp));
            }
            case "!&": 
            case "nand": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.NAND));
            }
            case "!|": 
            case "nor": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.NOR));
            }
            case "!^": 
            case "xnor": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.XNOR));
            }
            case "!": 
            case "not": {
                return Bool.stdResult(this.not(cp));
            }
            case "&": 
            case "and": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.AND));
            }
            case "|": 
            case "or": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.OR));
            }
            case "^": 
            case "xor": {
                return Bool.stdResult(this.comparsion2(cp, COMPARE2.XOR));
            }
        }
        return null;
    }

    @Override
    public Integer compareTo2(I_AtomicValue o) {
        if (o instanceof Bool) {
            return new Boolean(this.value).compareTo(((Bool)o).gValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.BOOL, to, this, this.gValue());
    }

    @Override
    public Boolean gValue() {
        return this.value;
    }

    @Override
    public String toDebug(CurProc cp) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        int val;
        I_Object raw = cp.parsExt(Bool.class, this, new Class[][]{{Bool.class, Char.class, Int.class, Dec.class}})[0];
        int par = Lib_Convert.getIntValue(cp, raw);
        int n = val = this.value ? 1 : 0;
        if (m == COMPARE.G) {
            return Bool.getObject(val > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject(val < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject(val >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject(val <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject(val == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject(val != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    protected Bool comparsion2(CurProc cp, COMPARE2 m) {
        boolean val = this.value;
        if (val) {
            switch (m) {
                case OR: {
                    return TRUE;
                }
                case NOR: {
                    return FALSE;
                }
            }
        } else {
            switch (m) {
                case AND: {
                    return FALSE;
                }
                case NAND: {
                    return TRUE;
                }
            }
        }
        I_Object raw = cp.pars(Bool.class, this, Bool.class)[0];
        boolean par = Lib_Convert.getBoolValue(cp, raw);
        switch (m) {
            case AND: {
                return Bool.getObject(val && par);
            }
            case OR: {
                return Bool.getObject(val || par);
            }
            case XOR: {
                return Bool.getObject(val ^ par);
            }
            case NAND: {
                return Bool.getObject(!val || !par);
            }
            case NOR: {
                return Bool.getObject(!val && !par);
            }
            case XNOR: {
                return Bool.getObject(!(val ^ par));
            }
        }
        throw Err.todo(new Object[]{cp, m});
    }

    private I_Object add(CurProc cp) {
        int vn;
        I_Object para = cp.pars(null, this, A_Atomic.class)[0];
        boolean vb = this.value;
        if (para instanceof Str) {
            return new Str(String.valueOf(vb) + ((Str)para).gValue());
        }
        if (para instanceof Char) {
            return new Char((char)((vb ? (char)'\u0001' : '\u0000') + ((Char)para).gValue().charValue()));
        }
        int n = vn = vb ? 1 : 0;
        if (para instanceof JMo_Long) {
            return new JMo_Long((long)vn + ((JMo_Long)para).gValue());
        }
        if (para instanceof Bool) {
            return this.comparsion2(cp, COMPARE2.AND);
        }
        if (para instanceof I_Decimal) {
            return new Dec((double)vn + (Double)((I_Decimal)para).gValue());
        }
        if (para instanceof I_Integer) {
            return new Int(vn + (Integer)((I_Integer)para).gValue());
        }
        return null;
    }

    private Bool not(CurProc cp) {
        cp.pars(Bool.class);
        return Bool.getObject(!this.value);
    }

    static enum COMPARE2 {
        AND,
        OR,
        XOR,
        NAND,
        NOR,
        XNOR;

    }
}

