/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.error;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.convert.ConvSequ;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_Error;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ERROR_GROUP;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.struct.runtime.CurProc;

public class ErrorBaseDebug
extends ErrorBase
implements I_Error {
    private static final long serialVersionUID = 8587625424636880857L;
    private final DebugInfo source;
    private final String call;
    private final String instance;
    private final ERROR_GROUP group;

    protected ErrorBaseDebug(ERROR_GROUP group, String message, String call, String detail, CurProc cp, DebugInfo source) {
        super(message, detail);
        this.group = group;
        this.source = source;
        this.call = call;
        this.instance = cp == null ? null : cp.instance.toDebug(cp);
    }

    @Override
    public Iterable<Object> getDetails() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getDetail() != null) {
            list.add("Detail: " + this.getDetail());
        }
        if (this.group != null) {
            list.add("Group : " + this.group.title + " (" + this.group.detail + ")");
        }
        if (this.source != null) {
            list.add("Source: " + this.source);
        }
        if (this.call != null) {
            list.add("Call  : " + this.call);
        }
        if (this.instance != null) {
            list.add("Inst. : " + this.instance);
        }
        return list;
    }

    public String getCall() {
        return this.call;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getSource() {
        return "" + this.source;
    }

    public ERROR_GROUP getGroup() {
        return this.group;
    }

    @Override
    public void addDetail(Object ... oa) {
        Err.todo(oa);
    }

    public String toInfo() {
        MList<String> list = new MList<String>();
        list.add(String.valueOf(this.getClass().getSimpleName()) + ": " + this.getMessage());
        for (Object d : this.getDetails()) {
            list.add(ConvObject.toText(d));
        }
        return ConvSequ.toText("\n", list);
    }
}

