/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.version.A_VersionData;
import de.mn77.base.version.A_VersionDataExt;
import de.mn77.base.version.VERSIONTYPE;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.base.version.VersionData_Single;
import de.mn77.base.version.VersionData_Standard;
import de.mn77.base.version.VersionData_Year;

public class VersionFormatter {
    public String format(VersionData_Single data, String format) {
        return this.iFormat(data, format);
    }

    public String format(VersionData_Year data, String format) {
        format = format.replaceAll("%y", "" + data.getYear());
        return this.iFormat(data, format);
    }

    public String format(VersionData_Standard data, String format) {
        format = format.replaceAll("%1", "" + data.getNr());
        format = format.replaceAll("%2", "" + data.getMinor());
        return this.iFormat(data, format);
    }

    public String format(VersionData_ABC data, String format) {
        format = format.replaceAll("%1", "" + data.getNr());
        format = format.replaceAll("%2", "" + data.getMedium());
        format = format.replaceAll("%3", "" + data.getFixnr());
        int dev = data.getDev();
        format = format.replaceAll("%D", dev > 0 ? "-dev" + dev : "");
        return this.iFormat(data, format);
    }

    private String iFormat(A_VersionDataExt data, String format) {
        format = format.replaceAll("%1", "" + data.getNr());
        format = format.replaceAll("%n", "" + data.getNr());
        boolean rel = data.getType() == VERSIONTYPE.RELEASE;
        boolean fix = data.getFixnr() <= 0;
        String tz = rel ? "" : ("" + data.getType().token).toLowerCase();
        format = format.replaceAll("%\\?tf", String.valueOf(tz) + (fix ? "" : String.valueOf(rel ? "-" : "") + data.getFixnr()));
        format = format.replaceAll("%t", "" + data.getType().token);
        format = format.replaceAll("%\\?t", tz);
        format = format.replaceAll("%f", fix ? "" : "" + data.getFixnr());
        format = format.replaceAll("%-f", fix ? "" : "-" + data.getFixnr());
        return this.iFormat2(data, format);
    }

    private String iFormat2(A_VersionData data, String format) {
        format = format.replaceAll("%dd.mm.yyyy", data.getTime().getDate().toString(FORM_DATE.GROUP_DEFAULT));
        format = format.replaceAll("%b", "" + data.getBuild());
        return format;
    }
}

