/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.A_DataType;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.error.Err;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MTime
extends A_DataType<I_Time>
implements I_Time {
    private final int hour;
    private final int minutes;
    private final int seconds;

    public MTime() {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeZone(TimeZone.getTimeZone("ECT"));
        this.hour = greg.get(11);
        this.minutes = greg.get(12);
        this.seconds = greg.get(13);
    }

    public MTime(int hour, int min, int sec) {
        this.hour = this.iCheck24(hour);
        this.minutes = this.iCheck60(min);
        this.seconds = this.iCheck60(sec);
    }

    public MTime(Calendar c) {
        Err.ifNull(c);
        this.hour = c.get(11);
        this.minutes = c.get(12);
        this.seconds = c.get(13);
    }

    public MTime(long milliSec) {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeZone(TimeZone.getDefault());
        greg.setTimeInMillis(milliSec);
        this.hour = greg.get(11);
        this.minutes = greg.get(12);
        this.seconds = greg.get(13);
    }

    public MTime(String s) {
        block4: {
            Err.ifNull(s);
            if (s.matches("[0-2][0-9]:[0-5][0-9]:[0-5][0-9]")) {
                this.hour = this.iCheck24(this.iParseNumber(s.substring(0, 2)));
                this.minutes = this.iCheck60(this.iParseNumber(s.substring(3, 5)));
                this.seconds = this.iCheck60(this.iParseNumber(s.substring(6, 8)));
                break block4;
            }
            if (s.matches("[0-2][0-9]:[0-5][0-9]")) {
                this.hour = this.iCheck24(this.iParseNumber(s.substring(0, 2)));
                this.minutes = this.iCheck60(this.iParseNumber(s.substring(3, 5)));
                this.seconds = 0;
                break block4;
            }
            throw Err.invalid(s);
        }
    }

    @Override
    public I_Time getAddHours(int amount) {
        int sum = this.iToSec(this.hour + amount, this.minutes, this.seconds);
        return this.iSecToTime(sum);
    }

    @Override
    public I_Time getAddMinutes(int amount) {
        int sum = this.iToSec(this.hour, this.minutes + amount, this.seconds);
        return this.iSecToTime(sum);
    }

    @Override
    public I_Time getAddSeconds(int amount) {
        int sum = this.iToSec(this.hour, this.minutes, this.seconds + amount);
        return this.iSecToTime(sum);
    }

    @Override
    public I_Time getRoundSec() {
        int minadd = this.seconds >= 30 ? 1 : 0;
        int sum = this.iToSec(this.hour, this.minutes + minadd, 0);
        return this.iSecToTime(sum);
    }

    @Override
    public int getHours() {
        return this.hour;
    }

    @Override
    public int getMinutes() {
        return this.minutes;
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    @Override
    public boolean isGreater(I_Time than) {
        long other = Lib_DateTime.toMilliSec(than.getHours(), than.getMinutes(), than.getSeconds(), 0);
        long current = Lib_DateTime.toMilliSec(this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        return current > other;
    }

    @Override
    public boolean isEqual(I_Time t) {
        return t.getHours() == this.getHours() && t.getMinutes() == this.getMinutes() && t.getSeconds() == this.getSeconds();
    }

    @Override
    public int diffSeconds(I_Time other) {
        long other2 = Lib_DateTime.toMilliSec(other.getHours(), other.getMinutes(), other.getSeconds(), 0);
        long current = Lib_DateTime.toMilliSec(this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        return (int)(other2 - current) / 1000;
    }

    public int diffMinutes(I_Time other) {
        return this.diffSeconds(other) / 60;
    }

    public int diffHours(I_Time other) {
        return this.diffSeconds(other) / 60 / 60;
    }

    @Override
    public String toString() {
        return FormDateTime.toText(this, FORM_TIME.GROUP_HHMMSS);
    }

    @Override
    public String toString(Object ... form) {
        return FormDateTime.toText(this, form);
    }

    @Override
    public String toStringIT() {
        return this.toString();
    }

    private int iCheck60(int value) {
        Err.ifOutOfBounds(0.0, 59.0, value);
        return value;
    }

    private int iCheck24(int hour) {
        Err.ifOutOfBounds(0.0, 23.0, hour);
        return hour;
    }

    private int iParseNumber(String s) {
        Err.ifOutOfBounds(1.0, 2.0, s.length());
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            throw Err.invalid(s);
        }
    }

    private int iToSec(int hour, int min, int sec) {
        return hour * 60 * 60 + min * 60 + sec;
    }

    private MTime iSecToTime(int sec) {
        int hh = sec / 3600;
        int mm = (sec -= hh * 3600) / 60;
        int ss = sec -= mm * 60;
        while (hh > 23) {
            hh -= 24;
        }
        return new MTime(hh, mm, ss);
    }
}

