/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.cli;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.convert.ConvArray;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import java.io.IOException;
import org.jmo_lang.JMO;
import org.jmo_lang.cli.CLI;
import org.jmo_lang.cli.info.Lib_CliInfo;
import org.jmo_lang.core.App;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.tools.Lib_Error;

public class JMo {
    public static final String COPYRIGHT = "2017-2021  Michael Nitsche (DE, \u00dcbersee)";
    private boolean parseOnly = false;
    private String directExec = null;
    private boolean debug = false;

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors((boolean)false);
        try {
            JMo jmo = new JMo();
            jmo.start(args);
        }
        catch (Throwable t) {
            Err.exit((Throwable)Lib_Error.wrap((Throwable)t));
        }
    }

    public void start(String[] args) throws Err_FileSys, IOException {
        if ((args = this.args(args)) != null) {
            if (args.length == 0 && this.directExec == null) {
                CLI cli = new CLI();
                cli.start(this.parseOnly, this.debug);
                return;
            }
            Parser_App parser = new Parser_App(false);
            if (this.debug) {
                parser.setDebug();
            }
            App app = null;
            if (this.directExec != null) {
                app = parser.parseText(this.directExec.trim());
            } else {
                MFile file = new MFile(args[0]);
                if (!file.exists()) {
                    MOut.print((Object[])new Object[]{"Missing file: " + file.getPathAbsolute()});
                    return;
                }
                app = parser.parseFile(file.getFile());
                args = Lib_Array.cutFrom((String[])args, (int)1);
            }
            if (this.parseOnly) {
                MOut.print((Object[])new Object[]{"Test okay, no parse errors found."});
            } else {
                app.exec(args);
            }
        }
    }

    private String[] args(String[] args) {
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (!s.startsWith("-")) {
                return Lib_Array.cutFrom((String[])args, (int)i);
            }
            switch (s) {
                case "-t": 
                case "--test": {
                    this.parseOnly = true;
                    break;
                }
                case "--debug": 
                case "-d": {
                    this.debug = true;
                    MOut.setJavaErrors((boolean)true);
                    MOut.debugDetail();
                    break;
                }
                case "-e": 
                case "--exec": {
                    int len = args.length - i - 1;
                    if (len == 0) {
                        throw new Err_Runtime("Invalid arguments", new Object[]{"Missing code after \"-e/--exec\""});
                    }
                    this.directExec = ConvArray.toString((String)" ", (Object[])Lib_Array.cutFrom((String[])args, (int)(++i)));
                    break;
                }
                case "--license": {
                    String licenseMessage = "JM\u00b0  Copyright (C):  2017-2021  Michael Nitsche (DE, \u00dcbersee)\n\n" + Lib_CliInfo.license();
                    MOut.print((Object[])new Object[]{licenseMessage});
                    return null;
                }
                case "--version": {
                    String format = "%1.%2.%3%D";
                    MOut.print((Object[])new Object[]{"JM\u00b0  " + JMO.VERSION.toFormat("%1.%2.%3%D")});
                    return null;
                }
                case "--help": {
                    MOut.print((Object[])new Object[]{Lib_CliInfo.help()});
                    return null;
                }
                default: {
                    throw new Err_Runtime("Unknown argument for JM\u00b0", new Object[]{s});
                }
            }
            ++i;
        }
        return new String[0];
    }
}

