/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing.defs;

import de.mn77.base.sys.file.Lib_Jar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.InputStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SpringLayout;
import javax.swing.plaf.BorderUIResource;
import org.jmo_lang.ide.swing.action.JayMo_Actions;
import org.jmo_lang.ide.swing.defs.FileEditor;
import org.jmo_lang.ide.swing.defs.TextOutput;
import org.jmo_lang.ide.swing.defs.TextResult;

public class EditorMainPanel
extends JPanel {
    private static final long serialVersionUID = 6516457542639499873L;
    private final FileEditor compCode;
    private final TextOutput compOutput = new TextOutput();
    private final TextResult compResult = new TextResult();
    private JSplitPane splitPane = null;

    public EditorMainPanel(JayMo_Actions actions) {
        super(new FlowLayout());
        Font font = null;
        int font_char_width = -1;
        int font_line_height = -1;
        try {
            InputStream is = Lib_Jar.getJarStream((String)"/jar/font/dejavu/DejaVuSansMono.ttf");
            font = Font.createFont(0, is).deriveFont(15.0f);
            font_char_width = 9;
            font_line_height = 18;
        }
        catch (Exception e) {
            font = new Font("DialogInput", 0, 14);
            font_char_width = 8;
            font_line_height = 17;
        }
        this.compCode = new FileEditor(font_char_width, font_line_height, actions);
        this.compCode.setFont(font);
        this.compOutput.setFont(font);
        this.compResult.setFont(font);
        JScrollPane scroll1 = new JScrollPane(this.compCode);
        JScrollPane scroll2 = new JScrollPane(this.compOutput);
        scroll1.getViewport().setBackground(Color.white);
        scroll1.setOpaque(true);
        scroll1.setBorder(BorderUIResource.getEtchedBorderUIResource());
        scroll2.setBorder(BorderUIResource.getEtchedBorderUIResource());
        JPanel left = new JPanel();
        SpringLayout leftLayout = new SpringLayout();
        left.setLayout(leftLayout);
        left.add(scroll1);
        leftLayout.putConstraint("West", (Component)scroll1, 0, "West", (Component)left);
        leftLayout.putConstraint("North", (Component)scroll1, 0, "North", (Component)left);
        leftLayout.putConstraint("East", (Component)scroll1, 0, "East", (Component)left);
        leftLayout.putConstraint("South", (Component)scroll1, 0, "South", (Component)left);
        JPanel right = new JPanel();
        SpringLayout rightLayout = new SpringLayout();
        right.setLayout(rightLayout);
        right.add(scroll2);
        right.add(this.compResult);
        rightLayout.putConstraint("West", (Component)this.compResult, 0, "West", (Component)right);
        rightLayout.putConstraint("East", (Component)this.compResult, 0, "East", (Component)right);
        rightLayout.putConstraint("South", (Component)this.compResult, 0, "South", (Component)right);
        rightLayout.putConstraint("West", (Component)scroll2, 0, "West", (Component)right);
        rightLayout.putConstraint("North", (Component)scroll2, 0, "North", (Component)right);
        rightLayout.putConstraint("East", (Component)scroll2, 0, "East", (Component)right);
        rightLayout.putConstraint("South", (Component)scroll2, 0, "North", (Component)this.compResult);
        this.splitPane = new JSplitPane(1, true, left, right);
        left.setMinimumSize(new Dimension(100, 100));
        right.setMinimumSize(new Dimension(0, 0));
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerLocation(Integer.MAX_VALUE);
        GridLayout layout2 = new GridLayout();
        layout2.setColumns(1);
        layout2.setRows(1);
        this.setLayout(layout2);
        this.add(this.splitPane);
    }

    public void clearOutput() {
        this.compOutput.setText("");
        this.compResult.setText("");
    }

    public String getCode() {
        return this.compCode.getText();
    }

    public FileEditor getComponentEditor() {
        return this.compCode;
    }

    public TextResult getComponentResult() {
        return this.compResult;
    }

    public TextOutput getComponentOutput() {
        return this.compOutput;
    }

    public void setFocus() {
        this.compCode.grabFocus();
    }

    public void showOutput() {
        if (this.splitPane.getRightComponent().getWidth() < 75) {
            this.splitPane.setDividerLocation(this.splitPane.getWidth() * 62 / 100);
        }
    }

    public JSplitPane getSplit() {
        return this.splitPane;
    }
}

