/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.core.App;
import org.jmo_lang.core.Function;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.Instance;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.magic.I_Magic;
import org.jmo_lang.object.magic.var.MV_APP;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.ConstLet;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Prefix;

public class Lib_Type {
    public static void checkValidity(String typeName, Parser_Script parser) {
        Lib_Type.checkTypeValidity(typeName, parser, null);
    }

    public static void checkValidity(String typeName, CallRuntime cr) {
        Lib_Type.checkTypeValidity(typeName, null, cr);
    }

    private static void checkTypeValidity(String typeName, Parser_Script parser, CallRuntime cr) {
        char cl;
        DebugInfo debug;
        boolean parsetime = parser != null;
        DebugInfo debugInfo = debug = parsetime ? parser.getDebugInfo() : cr.getDebugInfo();
        if (typeName.length() == 0) {
            Lib_Type.invalidTypename("Type can't be empty!", parsetime, debug);
        }
        if ((cl = typeName.charAt(typeName.length() - 1)) == '_') {
            Lib_Type.invalidTypename("Type can't end with underline! Got: " + typeName, parsetime, debug);
        }
        int underlines = 0;
        boolean nextCapital = true;
        char[] cArray = typeName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char cx = cArray[n2];
            if (nextCapital) {
                nextCapital = false;
                if (cx == '_' && parser != null && parser.getCurrentPrefix() != null) {
                    nextCapital = true;
                } else if (cx < 'A' || cx > 'Z') {
                    Lib_Type.invalidTypename("Type must start with a capital letter! Got: '" + typeName + "'", parsetime, debug);
                }
            }
            if (!(cx >= 'A' && cx <= 'Z' || cx >= 'a' && cx <= 'z' || cx >= '0' && cx <= '9')) {
                if (cx == '_') {
                    ++underlines;
                    nextCapital = true;
                } else {
                    Lib_Type.invalidTypename("Invalid char '" + cx + "'! Got: " + typeName, parsetime, debug);
                }
            }
            ++n2;
        }
        if (underlines > 1) {
            Lib_Type.invalidTypename("Type can't have multiple underlines and namespaces: " + typeName, parsetime, debug);
        }
    }

    private static void invalidTypename(String detail, boolean parsetime, DebugInfo debug) {
        if (parsetime) {
            throw new ParseError("Invalid Type-Name!", detail, debug);
        }
        throw new ExecError("Invalid Type-Name!", detail, debug);
    }

    public static Class<?> getType(CallRuntime cr, I_Object o) {
        o = Lib_Convert.getValue(cr, o);
        return o.getClass();
    }

    public static boolean typeIs(CallRuntime cr, I_Object o, Class<?> ... ta) {
        o = Lib_Convert.getValue(cr, o);
        Class<?> typ = o.getClass();
        Class<?>[] classArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(typ)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getTypeString(I_Object obj) {
        return "<" + Lib_Type.getName(obj) + ">";
    }

    public static String getTypeString(Class<?> objClass, I_Object obj) {
        return "<" + Lib_Type.getName(objClass, obj) + ">";
    }

    public static String getName(I_Object obj) {
        return Lib_Type.getName(obj.getClass(), obj);
    }

    public static String getName(Class<?> objClass, I_Object obj) {
        Err.ifNull(objClass);
        if (objClass == App.class || objClass == MV_APP.class) {
            return "App";
        }
        if (objClass == Function.class) {
            return "Function";
        }
        if (objClass == LoopHandle.class) {
            return "Loop";
        }
        if (objClass == Var.class) {
            return "Var";
        }
        if (objClass == Const.class) {
            return "Const";
        }
        if (objClass == VarLet.class) {
            return "VarLet";
        }
        if (objClass == ConstLet.class) {
            return "ConstLet";
        }
        if (Lib_Class.isChildOf(objClass, I_Magic.class)) {
            Err.ifNull(obj);
            return obj.toString();
        }
        String s = objClass.getSimpleName();
        if (objClass == Instance.class) {
            String string = s = obj == null ? Instance.class.getSimpleName() : ((Instance)obj).getType().getName();
        }
        if (s.startsWith("JMo_")) {
            return s.substring(4);
        }
        if (s.startsWith("A_")) {
            return s.substring(2);
        }
        if (s.equals("I_AtomicValue")) {
            return "Atomic";
        }
        if (s.startsWith("I_")) {
            return s.substring(2);
        }
        return s;
    }

    public static String toStringExtWithType(CallRuntime cr, I_Object obj) {
        I_Object objReal = Lib_Convert.getValue(cr, obj);
        String argDebug = obj.toStringExt(cr);
        String typeName = Lib_Type.getName(objReal.getClass(), obj);
        return "<" + typeName + "> " + argDebug;
    }

    public static boolean isInstanceOf(I_Object o, String type) {
        if (type.startsWith("Java_")) {
            return o instanceof JMo_Java && ((JMo_Java)o).getJavaClassName().equals(Lib_Prefix.cutJava(type));
        }
        String[] stringArray = Lib_Type.getTypeNames(o);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String typesToString(I_Object obj) {
        String[] types = Lib_Type.getTypeNames(obj);
        StringBuilder sb = new StringBuilder();
        if (types.length > 1) {
            sb.append("(");
        }
        int tc = 0;
        while (tc < types.length) {
            String typename = types[tc];
            if (tc != 0) {
                sb.append(", ");
            }
            sb.append(typename);
            ++tc;
        }
        if (types.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static final String[] getTypeNames(I_Object obj) {
        Class<?>[] cla = Lib_Type.getTypeClasses(obj);
        int len = cla.length;
        String[] list = new String[len];
        int i = 0;
        while (i < len) {
            list[i] = Lib_Type.getName(cla[i], obj);
            ++i;
        }
        return list;
    }

    public static final Class<?>[] getTypeClasses(I_Object obj) {
        ArrayList list = new ArrayList();
        Class<?> cl = obj.getClass();
        while (cl != null) {
            String s = cl.getName();
            if (s.startsWith("org.jmo_lang")) {
                list.add(0, cl);
            }
            cl = cl.getSuperclass();
        }
        return list.toArray(new Class[list.size()]);
    }
}

