/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.error.I_ErrorDetails;
import org.jmo_lang.core.Type;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.JmoError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.tools.Lib_Output;

public class Lib_Error {
    public static void ifIs(CallRuntime cr, int shouldNotBe, int value, String title) {
        if (value == shouldNotBe) {
            throw new ExecError(cr, "Invalid " + title, "Value is not allowed: " + shouldNotBe);
        }
    }

    public static void ifNot(CallRuntime cr, int shouldBe, int value, String title) {
        if (value != shouldBe) {
            throw new ExecError(cr, "Invalid " + title, "Got: " + value + ", should be: " + shouldBe);
        }
    }

    public static void ifNotBetween(int min, int max, int value, String title, DebugInfo debug) {
        if (min == max && value != min) {
            throw new ParseError("Value out of bounds, invalid " + title, String.valueOf(title) + " is not: " + value, debug);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String s = min < max ? String.valueOf(min) + "-" + max : "" + min;
            throw new ParseError("Value out of bounds, invalid " + title, "Allowed are " + s + ", but got: " + value, debug);
        }
    }

    public static void ifOutOfBounds(CallRuntime cr, double abs, double value, String title) {
        Err.ifToSmall(0.0, abs);
        if (value > abs || value < -abs) {
            throw new ExecError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be between -" + abs + " and " + abs + ", but got: " + value);
        }
    }

    public static void ifOutOfBounds(CallRuntime cr, int abs, int value, String title) {
        Err.ifToSmall(0.0, abs);
        if (value > abs || value < -abs) {
            throw new ExecError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be between -" + abs + " and " + abs + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, int min, int max, int value, String title) {
        if (min == max && value != min) {
            throw new ExecError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be " + min + ", but got: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String s = min < max ? String.valueOf(min) + "-" + max : "" + min;
            throw new ExecError(cr, "Value out of bounds, invalid " + title, "Got: " + value + ", allowed: " + s);
        }
    }

    public static void ifNotBetween(CallRuntime cr, double min, double max, double value, String title) {
        if (min == max && value != min) {
            throw new ExecError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " is not: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String s = min < max ? String.valueOf(min) + "-" + max : "" + min;
            throw new ExecError(cr, "Value out of bounds, invalid " + title, "Got: " + value + ", allowed: " + s);
        }
    }

    public static void ifTooHigh(CallRuntime cr, int max, int value) {
        if (value > max) {
            throw new ExecError(cr, "Value too big", "Got: " + value + "  Maximum is: " + max);
        }
    }

    public static void ifTooSmall(CallRuntime cr, long min, long value) {
        if (value < min) {
            throw new ExecError(cr, "Value too small", "Got: " + value + "  Minimum is: " + min);
        }
    }

    public static CodeError notAllowed(CallRuntime cr) {
        throw new CodeError(cr, "Not allowed!", "You can't run this function!");
    }

    public static void ifEmpty(CallRuntime cr, int size, String type) {
        if (size == 0) {
            throw new ExecError(cr, "Can't access position", String.valueOf(type) + " is empty");
        }
    }

    public static void ifEmpty(CallRuntime cr, String value, String type) {
        if (value == null || value.length() == 0) {
            throw new ExecError(cr, "Got empty string", String.valueOf(type) + " is empty");
        }
    }

    public static void ifArgs(int got, int min, Integer max, CallRuntime cr, I_Object obj) {
        String want = null;
        if (max == null) {
            if (got < min) {
                want = " at least " + min;
            }
        } else if (!Lib_Math.isBetween(got, min, max)) {
            want = min + (min != max ? "-" + max : "");
        }
        if (want != null) {
            Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, cr.call.method, false);
            throw new CodeError(cr, "Invalid amount of arguments", "Got " + got + ", but need " + want + " for: " + (String)g.o1);
        }
    }

    public static void ifArgs(int got, int min, Integer max, String subject, DebugInfo debug) {
        String want = null;
        if (max == null) {
            if (got < min) {
                want = "" + min;
            }
        } else if (!Lib_Math.isBetween(got, min, max)) {
            String string = want = min != max ? String.valueOf(min) + "-" + max : "" + min;
        }
        if (want != null) {
            throw new CodeError("Invalid amount of arguments", "Got " + got + ", but need " + want + " for: " + subject, debug);
        }
    }

    public static void ifNotControl(CallRuntime cr, Type type) {
        if (!type.isControl()) {
            throw new ExecError(cr, "This type has no control functionality!", "Type is defined with \"()\", maybe define it with \"()?\"");
        }
    }

    public static String collectMessages(Throwable t) {
        StringBuffer sb = new StringBuffer();
        sb.append(t.getMessage());
        while (t.getCause() != null) {
            t = t.getCause();
            sb.append(" / ");
            sb.append(t.getMessage());
        }
        return sb.toString();
    }

    public static Throwable wrap(Throwable t) {
        if (t instanceof ErrorBaseDebug) {
            return t;
        }
        if (t instanceof Err_Exception || t instanceof Err_Runtime) {
            return new JmoError(t, Lib_Error.collectMessages(t), ConvSequence.toText(", ", ((I_ErrorDetails)((Object)t)).getDetails()), null);
        }
        return new JmoError(t, t.getClass().getSimpleName(), Lib_Error.collectMessages(t), null);
    }
}

