/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectManager;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_Tree
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '>' && s.startsWith(">>>>");
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        int end = s.indexOf("<<<<", 4);
        String rem = end == -1 ? "" : s.substring(end + 4);
        String s2 = s.substring(4, end);
        boolean lazy = false;
        if (rem.startsWith("?")) {
            lazy = true;
            rem = rem.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(".build(");
        this.iParse(sb, s2, lazy);
        sb.append(")");
        I_Object obj = ObjectManager.createNew(parser.app, current, "Tree", new Call[0], parser.getDebugInfo());
        return new Group2<I_Object, String>(obj, String.valueOf(sb.toString()) + rem);
    }

    private void iParse(StringBuilder sb, String spar, boolean lazy) {
        String[] lines = this.iParseSplit(spar);
        this.iParseAddNode(sb, lines, 0, -1, lazy);
    }

    private int iParseAddNode(StringBuilder sb, String[] lines, int next, int baseIndent, boolean lazy) {
        boolean open = false;
        int i = next;
        while (i < lines.length) {
            String s = lines[i];
            if (s.trim().length() != 0) {
                int curIndent;
                if (baseIndent == -1) {
                    baseIndent = Lib_Parser.getDepth(s);
                }
                if ((curIndent = Lib_Parser.getDepth(s)) < baseIndent) {
                    sb.append(')');
                    return i;
                }
                if (curIndent == baseIndent) {
                    if (open) {
                        sb.append("),");
                        open = false;
                    }
                    Group2<String, String> name_value = this.iSplitNameValue(s.trim(), lazy);
                    sb.append("TreeNode(" + (String)name_value.o1 + ',' + (String)name_value.o2);
                    open = true;
                } else {
                    Err.ifToBig(baseIndent + 1, curIndent);
                    sb.append(',');
                    i = this.iParseAddNode(sb, lines, i, curIndent, lazy) - 1;
                }
            }
            ++i;
        }
        if (open) {
            sb.append(')');
            open = false;
        }
        return lines.length;
    }

    private Group2<String, String> iSplitNameValue(String s, boolean lazy) {
        String name = s;
        String value = null;
        int idx = s.indexOf(58);
        if (idx == -1) {
            idx = s.indexOf(61);
        }
        if (idx >= 0) {
            name = s.substring(0, idx).trim();
            value = s.substring(idx + 1).trim();
        }
        if (name.indexOf("\\t") > -1) {
            name = this.iReplaceCombineChars(name);
        }
        if (value != null && value.indexOf("\\t") > -1) {
            value = value.replace("\\t", ",");
        }
        return new Group2<String, String>(String.valueOf('\"') + name + '\"', value == null ? "nil" : (lazy ? String.valueOf('\"') + value + '\"' : value));
    }

    private String iReplaceCombineChars(String key) {
        int next;
        int offset = 0;
        String buffer = null;
        do {
            if ((next = this.iNextCombineChar(key, offset)) == -1) {
                if (buffer == null) {
                    return key;
                }
                return String.valueOf(buffer) + key.substring(offset).trim();
            }
            String part = String.valueOf(key.substring(offset, next)) + ',';
            buffer = buffer == null ? part : String.valueOf(buffer) + part;
        } while ((offset = next < 0 ? next : next + 2) >= 0);
        throw Err.invalid(key, offset, buffer);
    }

    private int iNextCombineChar(String key, int offset) {
        boolean step1 = false;
        int i = offset;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (c == '\\') {
                step1 = true;
            } else {
                if (step1 && c == 't') {
                    return i - 1;
                }
                step1 = false;
            }
            ++i;
        }
        return -1;
    }

    private String[] iParseSplit(String spar) {
        ArrayList<String> list = new ArrayList<String>();
        String curline = "";
        int i = 0;
        while (i < spar.length()) {
            if (spar.startsWith("\\n", i)) {
                ++i;
                if (!curline.trim().endsWith(",")) {
                    list.add(curline);
                    curline = "";
                }
            } else {
                curline = String.valueOf(curline) + spar.charAt(i);
            }
            ++i;
        }
        if (curline.length() > 0) {
            list.add(curline);
        }
        return list.toArray(new String[list.size()]);
    }
}

