/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectManager;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.tools.Lib_Error;

public class ParseObj_Table
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '|' && s.startsWith("||||");
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        int end = s.indexOf("||||", 4);
        String rem = end == -1 ? "" : s.substring(end + 4);
        I_List<String> lines = ConvString.toMList("\\n", s.substring(4, end));
        StringBuilder sb = new StringBuilder();
        int tableWidth = -1;
        for (String line : lines) {
            String lineTrimmed = line.trim();
            if (lineTrimmed.length() == 0) continue;
            sb.append(".add(");
            int lineWidth = this.countColumns(line);
            if (tableWidth == -1) {
                tableWidth = lineWidth;
            } else {
                Lib_Error.ifArgs(lineWidth, tableWidth, (Integer)tableWidth, "cells in row", parser.getDebugInfo());
            }
            sb.append(line.replace("\\t", ","));
            sb.append(")");
        }
        Call[] args = new Call[]{new Call(current, new Int(tableWidth), parser.getDebugInfo())};
        I_Object obj = ObjectManager.createNew(parser.app, current, "Table", args, parser.getDebugInfo());
        return new Group2<I_Object, String>(obj, String.valueOf(sb.toString()) + rem);
    }

    private int countColumns(String line) {
        int result = 0;
        int start = 0;
        while ((start = line.indexOf("\\t", start) + 1) != 0) {
            ++result;
        }
        return result + 1;
    }
}

