/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.core.App;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.parser.I_DebugInfo;
import org.jmo_lang.parser.Parser_Block;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_ScriptFilter;
import org.jmo_lang.tools.LineBuffer;

public class Parser_Script
implements I_DebugInfo {
    public final LineBuffer buffer;
    public final App app;
    private String currentPrefix = null;

    public Parser_Script(App app, String filename, String text) {
        Group2<String[], int[]> g = Lib_ScriptFilter.filter(filename, text);
        String[] lines = (String[])g.o1;
        this.iCombineLines(lines);
        this.buffer = new LineBuffer(filename, lines, (int[])g.o2);
        this.app = app;
    }

    public void parse() {
        Parser_Block parserBlock = new Parser_Block();
        parserBlock.parse(this, this.app.getRootType(), null, this.app.getRootType().getBlock(), true);
    }

    public void setCurrentPrefix(String prefix) {
        this.currentPrefix = prefix == null || prefix.length() == 0 ? null : prefix;
    }

    public String getCurrentPrefix() {
        return this.currentPrefix;
    }

    @Override
    public DebugInfo getDebugInfo() {
        return this.buffer.gDebugInfo();
    }

    private void iCombineLines(String[] lines) {
        int max;
        int bottom = max = lines.length - 1;
        while (bottom >= 1) {
            String uTrim;
            int top = bottom - 1;
            String lineTopTrim = lines[top].trim();
            if (lineTopTrim.endsWith(",") || lineTopTrim.endsWith("[") || lineTopTrim.endsWith("(")) {
                int n = top;
                lines[n] = String.valueOf(lines[n]) + lines[bottom].trim();
                lines[bottom] = null;
            }
            String string = uTrim = lines[bottom] == null ? "" : lines[bottom].trim();
            if (uTrim.length() > 0) {
                switch (uTrim.charAt(0)) {
                    case ',': 
                    case '.': 
                    case ']': {
                        int depth_bottom = Lib_Parser.getDepth(lines[bottom]);
                        int depth_top = Lib_Parser.getDepth(lines[top]);
                        if (depth_bottom < depth_top) break;
                        int n = top;
                        lines[n] = String.valueOf(lines[n]) + lines[bottom].trim();
                        lines[bottom] = null;
                    }
                }
            }
            --bottom;
        }
    }
}

