/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.struct.list.MList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.magic.I_Magic;
import org.jmo_lang.parser.PARSER_LEVEL;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.parser.func.ParseFunc_Direct;
import org.jmo_lang.parser.func.ParseFunc_EventHandler;
import org.jmo_lang.parser.func.ParseFunc_EventStart;
import org.jmo_lang.parser.func.ParseFunc_Let;
import org.jmo_lang.parser.func.ParseFunc_Math;
import org.jmo_lang.parser.func.ParseFunc_MathLet;
import org.jmo_lang.parser.func.ParseFunc_PosSetGet;
import org.jmo_lang.parser.func.ParseFunc_PropertySet;
import org.jmo_lang.parser.func.ParseFunc_Range;
import org.jmo_lang.parser.func.ParseFunc_SelectUpdate;
import org.jmo_lang.parser.func.ParseFunc_StringSetGet;
import org.jmo_lang.parser.func.ParseFunc_VarIncDec;
import org.jmo_lang.tools.Lib_MagicVar;
import org.jmo_lang.tools.Lib_Type;

public class ParseManagerFunc {
    private final I_ParseFunc[] pool = new I_ParseFunc[]{new ParseFunc_PosSetGet(), new ParseFunc_StringSetGet(), new ParseFunc_SelectUpdate(), new ParseFunc_VarIncDec(), new ParseFunc_Let(), new ParseFunc_MathLet(), new ParseFunc_Range(), new ParseFunc_Math(), new ParseFunc_EventStart(), new ParseFunc_PropertySet(), new ParseFunc_Direct(), new ParseFunc_EventHandler()};
    private I_ParseFunc[] active = new I_ParseFunc[this.pool.length];

    public ParseManagerFunc() {
        System.arraycopy(this.pool, 0, this.active, 0, this.pool.length);
    }

    public I_ParseFunc getParser(I_Object obj, String s, DebugInfo debugInfo) {
        char c0 = s.charAt(0);
        I_ParseFunc[] i_ParseFuncArray = this.active;
        int n = this.active.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParseFunc pf = i_ParseFuncArray[n2];
            if (pf.hits(c0, s)) {
                return pf;
            }
            ++n2;
        }
        if (c0 == ',') {
            throw new ParseError("Unexpected argument separator", s, debugInfo);
        }
        if (c0 == ')' || c0 == '}' || c0 == ']') {
            throw new ParseError("Unexpected closing bracket", "Got: " + s, debugInfo);
        }
        if (c0 >= '0' && c0 <= '9' || c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z' || c0 == '_') {
            throw new ParseError("Unexpected argument", "Missing brackets, got: " + s, debugInfo);
        }
        String detail = obj == null ? "Unexpected argument(s) or missing brackets for" : (obj instanceof I_Magic ? "For magic " + Lib_MagicVar.magicTypeToString((I_Magic)((Object)obj)) + " '" + obj.toString() + "' got" : "For object '" + obj.toString() + "' from type " + Lib_Type.getTypeString(obj) + " got");
        throw new ParseError("Invalid function call", String.valueOf(detail) + ": '" + s + "'", debugInfo);
    }

    public void strictLevel(PARSER_LEVEL level) {
        MList<I_ParseFunc> list = new MList<I_ParseFunc>();
        I_ParseFunc[] i_ParseFuncArray = this.active;
        int n = this.active.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParseFunc pf = i_ParseFuncArray[n2];
            switch (level) {
                case INSANE: {
                    if (pf instanceof ParseFunc_Let || pf instanceof ParseFunc_Math) break;
                }
                case HIGH: {
                    if (pf instanceof ParseFunc_PosSetGet || pf instanceof ParseFunc_VarIncDec || pf instanceof ParseFunc_MathLet || pf instanceof ParseFunc_SelectUpdate || pf instanceof ParseFunc_StringSetGet || pf instanceof ParseFunc_PropertySet || pf instanceof ParseFunc_Range) break;
                }
                case MEDIUM: {
                    if (pf instanceof ParseFunc_SelectUpdate) break;
                }
                default: {
                    list.add(pf);
                }
            }
            ++n2;
        }
        this.active = list.toArray(I_ParseFunc.class);
    }

    public void strictSave() {
        MList<I_ParseFunc> list = new MList<I_ParseFunc>();
        I_ParseFunc[] i_ParseFuncArray = this.active;
        int n = this.active.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParseFunc pf = i_ParseFuncArray[n2];
            list.add(pf);
            ++n2;
        }
        this.active = list.toArray(I_ParseFunc.class);
    }
}

