/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.VarArgsCallBuffer;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_TreeNode
extends A_Sequence {
    protected final ArrayList<JMo_TreeNode> nodes = new ArrayList();
    private I_Atomic name = null;
    private I_Object value = null;
    private final VarArgsCallBuffer callBuffer;

    public JMo_TreeNode(I_Atomic name) {
        this.name = name;
        this.callBuffer = null;
    }

    public JMo_TreeNode(I_Atomic name, I_Object value) {
        Err.ifNull(name);
        this.name = name;
        this.value = value;
        this.callBuffer = null;
    }

    public JMo_TreeNode(Call ... varArgs) {
        this.callBuffer = new VarArgsCallBuffer(varArgs);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.callBuffer != null) {
            I_Object[] args = this.callBuffer.init(cr, this);
            Lib_Error.ifArgs(args.length, 2, null, cr, this);
            this.name = (I_Atomic)cr.argType(args[0], I_AtomicValue.class);
            this.value = cr.argType(args[1], null);
            int i = 2;
            while (i < args.length) {
                JMo_TreeNode node = (JMo_TreeNode)cr.argType(args[i], JMo_TreeNode.class);
                this.nodes.add(node);
                ++i;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        ArrayList<String> target = new ArrayList<String>();
        for (JMo_TreeNode node : this.nodes) {
            node.describe(cr, target, left);
        }
        for (String s : target) {
            Lib_Output.out(cr.getApp(), s, true);
        }
    }

    public void describe(CallRuntime cr, ArrayList<String> target, int left) {
        target.add(String.valueOf(Lib_Parser.space(left)) + this.toString());
        for (JMo_TreeNode node : this.nodes) {
            node.describe(cr, target, left + 1);
        }
    }

    @Override
    public String toStringFull(CallRuntime cr) {
        ArrayList<String> target = new ArrayList<String>();
        for (JMo_TreeNode node : this.nodes) {
            node.describe(cr, target, 0);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : target) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.name == null ? "Tree" : this.name.toString()) + (this.value == null || this.value == Nil.NIL ? "" : ": " + this.value.toString());
    }

    public Group2<I_Atomic, I_Object> internalNameValue() {
        return new Group2<I_Atomic, I_Object>(this.name, this.value);
    }

    public List<JMo_TreeNode> internalNodes() {
        return this.nodes;
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getName": {
                return A_Object.stdResult(this.getName(cr));
            }
            case "setName": {
                return A_Object.stdResult(this.setName(cr));
            }
            case "getValue": {
                return A_Object.stdResult(this.getValue(cr));
            }
            case "setValue": {
                return A_Object.stdResult(this.setValue(cr));
            }
            case "addNode": 
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "addNodes": {
                return A_Object.stdResult(this.addNodes(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.removeNodes(cr));
            }
            case "remove": 
            case "removeNames": 
            case "--": {
                return A_Object.stdResult(this.removeNames(cr));
            }
            case "removeValues": {
                return A_Object.stdResult(this.removeValues(cr));
            }
            case "show": {
                cr.args();
                this.describe(cr, 0);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(0);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    protected int sequenceSize() {
        return this.nodes.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        if (args.length > 1) {
            return this.sequenceDeepGet(cr, args, 0, lazy);
        }
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(args[0])) continue;
            return node;
        }
        if (lazy) {
            A_Atomic apar = (A_Atomic)cr.argType(args[0], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            return node;
        }
        throw new ExecError(cr, "Node not found", "Can't find node with name: " + args[0].toString());
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 2, 1);
        if (args.length > 2) {
            this.sequenceDeepSet(cr, args, 1, args[0], lazy);
            return;
        }
        this.sequenceSet(cr, args[1], args[0], lazy);
    }

    @Override
    protected A_Sequence copy(CallRuntime cr) {
        Err.todo(cr);
        return null;
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        JMo_TreeNode hit = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(key)) continue;
            hit = node;
            break;
        }
        if (!lazy && hit == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + key.toString());
        }
        return hit == null && lazy ? Nil.NIL : hit.value;
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        JMo_TreeNode result = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            result = node;
            break;
        }
        if (lazy && result == null) {
            A_Atomic apar = (A_Atomic)cr.argType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            result = node;
        }
        if (result == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + keys[0].toString());
        }
        if (keys.length - offset == 1) {
            return result;
        }
        return result.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        if (keys.length - offset == 0) {
            this.value = value;
            return;
        }
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.argType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + keys[offset].toString());
        }
        found.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
    }

    private JMo_TreeNode setName(CallRuntime cr) {
        if (this.name == null) {
            throw new ExecError(cr, "Invalid name for root element", "Can't set value for root of the tree");
        }
        this.name = (A_Atomic)cr.args(this, A_Atomic.class)[0];
        return this;
    }

    private I_Object getName(CallRuntime cr) {
        cr.args();
        return this.name == null ? Nil.NIL : this.name;
    }

    private JMo_TreeNode setValue(CallRuntime cr) {
        if (this.name == null) {
            throw new ExecError(cr, "Invalid value for root element", "Can't set value for root of the tree");
        }
        this.value = cr.args(this, I_Object.class)[0];
        return this;
    }

    private I_Object getValue(CallRuntime cr) {
        cr.args();
        return this.value == null ? Nil.NIL : this.value;
    }

    private JMo_TreeNode add(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object key_node = args[0];
        int len = args.length;
        if (len == 1 && key_node instanceof JMo_TreeNode) {
            this.nodes.add((JMo_TreeNode)key_node);
            return (JMo_TreeNode)key_node;
        }
        A_Atomic aPar = (A_Atomic)cr.argType(key_node, A_Atomic.class);
        JMo_TreeNode result = len == 1 ? new JMo_TreeNode(aPar) : new JMo_TreeNode(aPar, args[1]);
        this.nodes.add(result);
        return result;
    }

    private JMo_TreeNode addNodes(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 0, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            if (arg instanceof JMo_TreeNode) {
                this.nodes.add((JMo_TreeNode)arg);
            } else {
                A_Atomic aPar = (A_Atomic)cr.argType(arg, A_Atomic.class);
                this.nodes.add(new JMo_TreeNode(aPar));
            }
            ++n2;
        }
        return this;
    }

    private I_Object removeNodes(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            boolean removed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.name.equals(arg)) {
                    this.nodes.remove(i);
                    removed = true;
                    break;
                }
                ++i;
            }
            if (!removed) {
                throw new ExecError(cr, "Node not found", "Can't find node with name: " + arg.toString());
            }
            ++n2;
        }
        return this;
    }

    private JMo_TreeNode removeNames(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.value != null && node.value.equals(arg)) {
                    this.nodes.remove(i);
                } else {
                    node.deepNameRemove(arg);
                }
                ++i;
            }
            ++n2;
        }
        return this;
    }

    private void deepNameRemove(I_Object toRemove) {
        int i = 0;
        while (i < this.nodes.size()) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.name.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepNameRemove(toRemove);
            }
            ++i;
        }
    }

    private JMo_TreeNode removeValues(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.value != null && node.value.equals(arg)) {
                    this.nodes.remove(i);
                } else {
                    node.deepValueRemove(arg);
                }
                ++i;
            }
            ++n2;
        }
        return this;
    }

    private void deepValueRemove(I_Object toRemove) {
        int i = 0;
        while (i < this.nodes.size()) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.value != null && node.value.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepValueRemove(toRemove);
            }
            ++i;
        }
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object pos, I_Object obj, boolean lazy) {
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(pos)) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.argType(pos, A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + pos.toString());
        }
        found.value = obj;
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        return this.nodes;
    }
}

