/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.I_AutoBlockDo;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Table;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Map
extends A_Sequence
implements I_AutoBlockDo {
    private final ArrayList<I_Object> keys;
    private final ArrayList<I_Object> values;

    public JMo_Map() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public JMo_Map(ArrayList<I_Object> keys, ArrayList<I_Object> objects) {
        this.keys = keys;
        this.values = objects;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.addAll(cr));
            }
            case "remove": 
            case "sub": {
                return A_Object.stdResult(this.remove(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "getKeys": {
                return A_Object.stdResult(this.getKeys(cr));
            }
            case "getValues": {
                return A_Object.stdResult(this.getValues(cr));
            }
            case "hasKey": 
            case "knowsKey": {
                return A_Object.stdResult(this.knowsKey(cr));
            }
            case "hasValue": 
            case "knowsValue": {
                return A_Object.stdResult(this.knowsValue(cr));
            }
            case "toTable": {
                return A_Object.stdResult(this.toTable(cr));
            }
            case "show": {
                cr.args();
                this.describe(cr, 0);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        int maxKeyLen = 0;
        for (I_Object key : this.keys) {
            maxKeyLen = Math.max(maxKeyLen, key.toStringExt(cr).length());
        }
        int i = 0;
        while (i < this.keys.size()) {
            String key = this.keys.get(i).toStringExt(cr);
            String value = this.values.get(i).toStringExt(cr);
            String s = String.valueOf(space) + FormString.length(maxKeyLen, key, false) + " -> " + value;
            Lib_Output.out(cr.getApp(), s, true);
            ++i;
        }
    }

    public I_Table<I_Object> copyToTable() {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int i = 0;
        while (i < this.keys.size()) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return tab;
    }

    public HashMap<I_Object, I_Object> copyToHashMap() {
        HashMap<I_Object, I_Object> result = new HashMap<I_Object, I_Object>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(this.keys.get(i), this.values.get(i));
            ++i;
        }
        return result;
    }

    public HashMap<String, I_Object> copyToStringMap(CallRuntime cr) {
        HashMap<String, I_Object> result = new HashMap<String, I_Object>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(Lib_Convert.getStringValue(cr, this.keys.get(i)), this.values.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Map) {
            ArrayList<I_Object> otherKeys = ((JMo_Map)obj).keys;
            if (this.keys.size() != otherKeys.size()) {
                return false;
            }
            int i = 0;
            while (i < this.keys.size()) {
                if (!this.keys.get(i).equals(otherKeys.get(i))) {
                    return false;
                }
                ++i;
            }
            ArrayList<I_Object> otherValues = ((JMo_Map)obj).values;
            if (this.values.size() != otherValues.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.values.size()) {
                if (!this.values.get(i2).equals(otherValues.get(i2))) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    private ObjectCallResult each(CallRuntime crOld) {
        JMo_KeyValue item;
        boolean varlet;
        I_Object[] args = crOld.argsFlex(this, 0, 1);
        boolean bl = varlet = args.length == 1;
        if (varlet) {
            crOld.argType(args[0], VarLet.class);
        }
        Call stream = crOld.getStream();
        Block block = crOld.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object res = this;
        int pos = 0;
        while (pos < this.keys.size()) {
            block13: {
                handle.startLap();
                item = new JMo_KeyValue(this.keys.get(pos), this.values.get(pos));
                if (varlet) {
                    Var o = ((VarLet)args[0]).getVar();
                    o.let(crNew, crNew, item);
                }
                if (block != null) {
                    try {
                        res = block.exec(crNew, item);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        switch (temp.getLevel()) {
                            case NEXT: {
                                break block13;
                            }
                            default: {
                                return temp.getLoopResult();
                            }
                        }
                    }
                }
                if (stream != null && block == null) {
                    res = crNew.execInit(stream, item);
                }
            }
            ++pos;
        }
        if (stream != null && block != null) {
            if (this.keys.size() == 0) {
                Err.todo("Map is empty!");
            }
            int last = this.keys.size() - 1;
            item = new JMo_KeyValue(this.keys.get(last), this.values.get(last));
            res = crNew.execInit(stream, item);
        }
        return new ObjectCallResult(res, true);
    }

    @Override
    protected int sequenceSize() {
        return this.keys.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Map(");
        int i = 0;
        while (i < this.keys.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.keys.get(i).toString());
            sb.append("->");
            sb.append(this.values.get(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private JMo_Map add(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        if (args.length == 1) {
            JMo_KeyValue kv = (JMo_KeyValue)cr.argType(args[0], JMo_KeyValue.class);
            this.iAdd(cr, kv.getKey(), kv.getValue());
        } else {
            this.iAdd(cr, args[0], args[1]);
        }
        return this;
    }

    private JMo_Map addAll(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 0, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            JMo_KeyValue kv = (JMo_KeyValue)cr.argType(arg, JMo_KeyValue.class);
            this.iAdd(cr, kv.getKey(), kv.getValue());
            ++n2;
        }
        return this;
    }

    @Override
    protected JMo_Map copy(CallRuntime cr) {
        cr.args(this, new Class[0]);
        ArrayList clonek = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.values.clone();
        return new JMo_Map(clonek, cloneo);
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetIndex(cr, key, !lazy);
            return lazy && i == -1 ? Nil.NIL : this.values.get(i);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    private JMo_List getKeys(CallRuntime cr) {
        cr.args(this, new Class[0]);
        ArrayList clone = (ArrayList)this.keys.clone();
        return new JMo_List(clone);
    }

    private JMo_List getValues(CallRuntime cr) {
        cr.args(this, new Class[0]);
        ArrayList clone = (ArrayList)this.values.clone();
        return new JMo_List(clone);
    }

    private Bool knowsKey(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        int knows = this.iGetIndex(cr, search, false);
        return knows == -1 ? Bool.FALSE : Bool.TRUE;
    }

    private Bool knowsValue(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        for (I_Object o : this.values) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_Map remove(CallRuntime cr) {
        I_Object key = cr.args(this, I_Object.class)[0];
        int i = this.iGetIndex(cr, key, true);
        this.keys.remove(i);
        this.values.remove(i);
        return this;
    }

    private JMo_Map clear(CallRuntime cr) {
        cr.args(this, new Class[0]);
        this.keys.clear();
        this.values.clear();
        return this;
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 2, 1);
        if (oa.length > 2) {
            this.sequenceDeepSet(cr, oa, 1, oa[0], lazy);
            return;
        }
        this.sequenceSet(cr, oa[1], oa[0], lazy);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        int pos = this.iGetIndex(cr, key, !lazy);
        if (lazy && pos < 0) {
            this.iAdd(cr, key, value);
        } else {
            this.values.set(pos, value);
        }
    }

    public void internalAdd(I_Object key, I_Object value) {
        this.keys.add(key);
        this.values.add(value);
    }

    private void iAdd(CallRuntime cr, I_Object key, I_Object value) {
        int i = this.iGetIndex(cr, key, false);
        if (i != -1) {
            throw new ExecError(cr, "Duplicated Key", "Got: " + key);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    private int iGetIndex(CallRuntime cr, I_Object key, boolean error) {
        int i = 0;
        while (i < this.keys.size()) {
            boolean equal = this.keys.get(i).toString().equals(key.toString());
            if (equal) {
                return i;
            }
            ++i;
        }
        if (error) {
            throw new ExecError(cr, "Unknown key", "Got: " + key);
        }
        return -1;
    }

    private I_Object toTable(CallRuntime cr) {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int len = this.keys.size();
        int i = 0;
        while (i < len) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return new JMo_Table(tab);
    }

    @Override
    protected JMo_KeyValue first(CallRuntime cr) {
        cr.args();
        return new JMo_KeyValue(this.keys.get(0), this.values.get(0));
    }

    @Override
    protected JMo_KeyValue last(CallRuntime cr) {
        cr.args();
        int idx = this.keys.size() - 1;
        return new JMo_KeyValue(this.keys.get(idx), this.values.get(idx));
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        I_Object key = cr.argType(keys[offset], I_Object.class);
        if (!this.keys.contains(key)) {
            if (lazy) {
                return Nil.NIL;
            }
            throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
        }
        if (offset == keys.length - 1) {
            int pos = this.iGetIndex(cr, key, true);
            return this.values.get(pos);
        }
        int pos = this.iGetIndex(cr, key, true);
        I_Object deeper = this.values.get(pos);
        if (!(deeper instanceof A_Sequence)) {
            throw new ExecError(cr, "Invalid type of value.", "Value to key " + key.toStringExt(cr) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        I_Object key = cr.argType(keys[offset], I_Object.class);
        int idx = this.iGetIndex(cr, key, !lazy);
        if (offset == keys.length - 1) {
            if (idx == -1) {
                if (lazy) {
                    this.keys.add(key);
                    this.values.add(value);
                    return;
                }
                throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
            }
            this.values.set(idx, value);
        } else {
            I_Object deeper;
            if (idx == -1) {
                if (lazy) {
                    this.keys.add(key);
                    this.values.add(new JMo_Map());
                    idx = this.values.size() - 1;
                } else {
                    throw new ExecError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
                }
            }
            if (!((deeper = this.values.get(idx)) instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of value.", "Value to key " + key.toStringExt(cr) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int i = this.iGetIndex(cr, key, false);
        return lazy && i == -1 ? Nil.NIL : this.values.get(i);
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.impossible(new Object[0]);
    }
}

