/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.datetime.A_DateTimeBase;
import org.jmo_lang.object.immute.datetime.JMo_DateTime;
import org.jmo_lang.object.immute.datetime.JMo_Time;
import org.jmo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Date
extends A_DateTimeBase {
    private I_Date date = null;
    private final Call[] init;

    public JMo_Date(I_Date date) {
        this.init = null;
        this.date = date;
    }

    public JMo_Date() {
        this.init = null;
    }

    public JMo_Date(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_Date(Call y, Call m, Call d) {
        this.init = new Call[]{y, m, d};
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.date != null) {
            return;
        }
        if (this.init == null) {
            this.date = new MDate();
        } else {
            if (this.init.length == 1) {
                String s = Lib_Convert.getStringValue(cr, cr.execInit(this.init[0], this));
                try {
                    this.date = new MDate(s);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Can't create Date-Object", String.valueOf(err.getMessage()) + " Got: Date(" + s + ")");
                }
            }
            int iy = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], this));
            Lib_Error.ifNotBetween(cr, 0, 2500, iy, "Year");
            int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], this));
            Lib_Error.ifNotBetween(cr, 1, 12, im, "Month");
            int id = Lib_Convert.getIntValue(cr, cr.execInit(this.init[2], this));
            Lib_Error.ifNotBetween(cr, 1, 31, id, "Day");
            try {
                this.date = new MDate(iy, im, id);
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, err.getMessage(), "Date(" + iy + "," + im + "," + id + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getYear": {
                return A_Object.stdResult(this.getYear(cr));
            }
            case "getMonth": {
                return A_Object.stdResult(this.getMonth(cr));
            }
            case "getDay": {
                return A_Object.stdResult(this.getDay(cr));
            }
            case "getWeekDay": 
            case "getDayOfWeek": {
                return A_Object.stdResult(this.getDayOfWeek(cr));
            }
            case "addDay": 
            case "addDays": {
                return A_Object.stdResult(this.add(cr, true));
            }
            case "addMonth": 
            case "addMonths": {
                return A_Object.stdResult(this.addsubMonths(cr, true));
            }
            case "addYears": 
            case "addYear": {
                return A_Object.stdResult(this.addsubYears(cr, true));
            }
            case "subDays": 
            case "subDay": {
                return A_Object.stdResult(this.sub(cr, true));
            }
            case "subMonth": 
            case "subMonths": {
                return A_Object.stdResult(this.addsubMonths(cr, false));
            }
            case "subYears": 
            case "subYear": {
                return A_Object.stdResult(this.addsubYears(cr, false));
            }
            case "setDay": {
                return A_Object.stdResult(this.setDay(cr));
            }
            case "setMonth": {
                return A_Object.stdResult(this.setMonth(cr));
            }
            case "setYear": {
                return A_Object.stdResult(this.setYear(cr));
            }
            case "diffDays": 
            case "diff": {
                return A_Object.stdResult(this.diffDays(cr));
            }
            case "diffMonths": {
                return A_Object.stdResult(this.diffMonths(cr));
            }
            case "diffYears": {
                return A_Object.stdResult(this.diffYears(cr));
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.date == null) {
            return "Date";
        }
        return "Date(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.date == null) {
            return "Date";
        }
        return this.date.toString();
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            return s.equals(this.date.toString()) || s.equals(this.date.toStringDE());
        }
        return this.equals(other);
    }

    @Override
    protected boolean[] compare2(CallRuntime cr) {
        JMo_Date d = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        boolean isEqual = this.date.isEqual(d.getInternalValue());
        boolean isGreater = this.date.isGreater(d.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_Date ? this.date.isEqual(((JMo_Date)arg).getInternalValue()) : false;
    }

    private Int diffDays(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffDays(arg.getInternalValue());
        return new Int(diff);
    }

    private Int diffMonths(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffMonths(arg.getInternalValue());
        return new Int(diff);
    }

    private Int diffYears(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffYears(arg.getInternalValue());
        return new Int(diff);
    }

    @Override
    protected A_DateTimeBase incdec2(boolean inc, int amount) {
        if (inc) {
            I_Date date2 = this.date.getAddDays(amount);
            return new JMo_Date(date2);
        }
        I_Date date2 = this.date.getAddDays(-amount);
        return new JMo_Date(date2);
    }

    @Override
    protected I_Object addsub(CallRuntime cr, boolean add) {
        return add ? this.add(cr, false) : this.sub(cr, false);
    }

    @Override
    protected JMo_Date limit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_Date.class, JMo_Date.class);
        I_Date min = ((JMo_Date)args[0]).date;
        I_Date max = ((JMo_Date)args[1]).date;
        if (this.date.isGreater(max)) {
            return (JMo_Date)args[1];
        }
        if (min.isGreater(this.date)) {
            return (JMo_Date)args[0];
        }
        return this;
    }

    private Int getDay(CallRuntime cr) {
        cr.args();
        return new Int(this.date.getDay());
    }

    private Int getMonth(CallRuntime cr) {
        cr.args();
        return new Int(this.date.getMonth());
    }

    private Int getYear(CallRuntime cr) {
        cr.args();
        return new Int(this.date.getYear());
    }

    private Int getDayOfWeek(CallRuntime cr) {
        cr.args();
        int dow = this.date.getDayOfWeek();
        if (dow == 0) {
            dow = 7;
        }
        return new Int(dow);
    }

    private I_Object add(CallRuntime cr, boolean days) {
        I_Object arg;
        I_Object i_Object = arg = days ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Date date2 = this.date.getAddDays(pari);
            return new JMo_Date(date2);
        }
        if (arg instanceof JMo_Time) {
            MDateTime dt = new MDateTime(this.date, ((JMo_Time)arg).getInternalTime());
            return new JMo_DateTime(dt);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private I_Object sub(CallRuntime cr, boolean days) {
        I_Object arg;
        I_Object i_Object = arg = days ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Date.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Date date2 = this.date.getAddDays(-pari);
            return new JMo_Date(date2);
        }
        if (arg instanceof JMo_Date) {
            int diff = this.date.diffDays(((JMo_Date)arg).getInternalValue());
            return new Int(-diff);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_Date addsubMonths(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddMonths(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date addsubYears(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddYears(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date setDay(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetDay(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date setMonth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetMonth(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date setYear(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetYear(pari);
        return new JMo_Date(date2);
    }

    @Override
    protected I_Object style(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.args();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "DD.MM.YYYY", this.getInternalDate(), null);
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "DD/MM/YYYY", this.getInternalDate(), null);
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "M/DD/YYYY", this.getInternalDate(), null);
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    @Override
    protected Str toStr(CallRuntime cr) {
        cr.args();
        return new Str(this.date.toString());
    }

    private I_Date getInternalValue() {
        return this.date;
    }

    @Override
    protected I_Date getInternalDate() {
        return this.date;
    }

    @Override
    protected I_Time getInternalTime() {
        return null;
    }
}

