/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.sys.MOut;
import org.jmo_lang.core.COMPARE;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.A_Immutable;
import org.jmo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public abstract class A_DateTimeBase
extends A_Immutable {
    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.addsub(cr, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.addsub(cr, false));
            }
            case "toStr": {
                return A_Object.stdResult(this.toStr(cr));
            }
            case "style": {
                return A_Object.stdResult(this.style(cr));
            }
            case "styleDE": 
            case "toStrDE": {
                return A_Object.stdResult(this.style(cr, COUNTRY.DE));
            }
            case "styleEN": 
            case "toStrEN": {
                return A_Object.stdResult(this.style(cr, COUNTRY.EN));
            }
            case "styleUS": 
            case "toStrUS": {
                return A_Object.stdResult(this.style(cr, COUNTRY.US));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.incdec(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.incdec(cr, false));
            }
            case "limit": {
                return A_Object.stdResult(this.limit(cr));
            }
            case "isLess": 
            case "<": {
                return A_Object.stdResult(this.compare(cr, COMPARE.L));
            }
            case "isGreater": 
            case ">": {
                return A_Object.stdResult(this.compare(cr, COMPARE.G));
            }
            case "<=": 
            case "isLessOrEqual": {
                return A_Object.stdResult(this.compare(cr, COMPARE.LE));
            }
            case "isGreaterOrEqual": 
            case ">=": {
                return A_Object.stdResult(this.compare(cr, COMPARE.GE));
            }
        }
        return this.call3(cr, method);
    }

    protected abstract I_Object style(CallRuntime var1, COUNTRY var2);

    protected abstract ObjectCallResult call3(CallRuntime var1, String var2);

    @Override
    public final void describe(CallRuntime cr, int left) {
        MOut.print(String.valueOf(Lib_Parser.space(left)) + this.toStringExt(cr));
    }

    private Bool compare(CallRuntime cr, COMPARE co) {
        boolean[] equal_greater = this.compare2(cr);
        boolean isEqual = equal_greater[0];
        boolean isGreater = equal_greater[1];
        boolean result = false;
        switch (co) {
            case L: {
                result = !isEqual && !isGreater;
                break;
            }
            case LE: {
                result = isEqual || !isGreater;
                break;
            }
            case G: {
                result = isGreater;
                break;
            }
            case GE: {
                result = isEqual || isGreater;
            }
        }
        return Bool.getObject(result);
    }

    @Override
    public abstract boolean equals(Object var1);

    protected abstract boolean[] compare2(CallRuntime var1);

    protected abstract I_Date getInternalDate();

    protected abstract I_Time getInternalTime();

    private Str style(CallRuntime cr) {
        String s = ((Str)cr.args(this, Str.class)[0]).getValue();
        return Lib_DateTime_Format.format(cr, s, this.getInternalDate(), this.getInternalTime());
    }

    protected abstract I_Object addsub(CallRuntime var1, boolean var2);

    private A_DateTimeBase incdec(CallRuntime cr, boolean inc) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int amount = 1;
        if (args.length == 1) {
            amount = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class));
        }
        return this.incdec2(inc, amount);
    }

    protected abstract A_DateTimeBase incdec2(boolean var1, int var2);

    protected abstract A_DateTimeBase limit(CallRuntime var1);

    protected abstract Str toStr(CallRuntime var1);

    public static enum COUNTRY {
        DE,
        EN,
        US;

    }
}

