/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.filesys.JMo_RandomAccessFile;
import org.jmo_lang.object.immute.datetime.JMo_DateTime;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;

public class JMo_File
extends JMo_Path
implements I_Object {
    public JMo_File(Call arg) {
        super(arg);
    }

    public JMo_File(File file) {
        super(file);
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        ObjectCallResult result = super.call2(cr, method);
        if (result != null) {
            return result;
        }
        switch (method) {
            case "getSuffix": {
                return A_Object.stdResult(this.getSuffix(cr));
            }
            case "getDir": {
                return A_Object.stdResult(this.getDir(cr));
            }
            case "getSize": {
                return A_Object.stdResult(this.getSize(cr));
            }
            case "getDateCreate": 
            case "cDate": {
                return A_Object.stdResult(this.getDateCreate(cr));
            }
            case "getDateModify": 
            case "mDate": {
                return A_Object.stdResult(this.getDateModify(cr));
            }
            case "exec": 
            case "open": {
                return A_Object.stdResult(this.open(cr));
            }
            case "create": 
            case "touch": {
                return A_Object.stdResult(this.create(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.clear(cr));
            }
            case "readLines": 
            case "lines": {
                return A_Object.stdResult(this.readLines(cr));
            }
            case "read": {
                return A_Object.stdResult(this.read(cr));
            }
            case "append": {
                return A_Object.stdResult(this.append(cr));
            }
            case "set": 
            case "write": {
                return A_Object.stdResult(this.write(cr));
            }
            case "rename": {
                return A_Object.stdResult(this.rename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.move(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.delete(cr));
            }
            case "directRead": {
                return A_Object.stdResult(this.randomAccess(cr, "r"));
            }
            case "directWrite": 
            case "randomAccess": 
            case "directReadWrite": {
                return A_Object.stdResult(this.randomAccess(cr, "rw"));
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.getInternalFile() == null) {
            return "File()";
        }
        return "File(\"" + this.getInternalFile().getAbsolutePath().toString() + '\"' + ")";
    }

    @Override
    public String toString() {
        if (this.getInternalFile() == null) {
            return "File";
        }
        return this.getInternalFile().getAbsolutePath().toString();
    }

    private I_Object randomAccess(CallRuntime cr, String mode) {
        cr.args();
        JMo_RandomAccessFile raf = new JMo_RandomAccessFile(this.getInternalFile(), mode);
        return raf;
    }

    private JMo_File rename(CallRuntime cr) {
        File newFile;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, arg);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "File-Rename failed", "No target-path allowed");
        }
        File oldFile = this.getInternalFile();
        boolean done = oldFile.renameTo(newFile = new File(newName = String.valueOf(oldFile.getParent()) + Sys.getSeperatorDir() + newName));
        if (!done) {
            throw new ExtError(cr, "File-Rename failed", String.valueOf(oldFile.getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.changeFile(newFile);
        return this;
    }

    private Nil delete(CallRuntime cr) {
        boolean deleted;
        File f = this.getInternalFile();
        if (f.exists() && !(deleted = f.delete())) {
            throw new ExtError(cr, "File-Delete-Error", this.getInternalFile().getAbsolutePath());
        }
        return Nil.NIL;
    }

    private JMo_File move(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Dir.class}})[0];
        Path source = this.getInternalFile().toPath();
        File target = null;
        if (arg instanceof Str) {
            Str str = (Str)arg;
            String newNamePath = Lib_Convert.getStringValue(cr, str);
            target = new File(newNamePath);
        } else {
            target = ((JMo_Dir)arg).getInternalFile();
        }
        try {
            boolean isDir = target.isDirectory();
            if (isDir) {
                target = target.toPath().resolve(source.getFileName()).toFile();
                Files.move(source, target.toPath(), new CopyOption[0]);
            } else {
                Files.move(source, target.toPath(), new CopyOption[0]);
            }
            this.changeFile(target);
            return this;
        }
        catch (NoSuchFileException e) {
            throw new ExtError(cr, "File-Move-Error", "Source file doesn't exist: \"" + source.toFile().getAbsolutePath() + "\"");
        }
        catch (FileAlreadyExistsException e) {
            throw new ExtError(cr, "File-Move-Error", "Target already exist: \"" + target.getAbsolutePath() + "\"");
        }
        catch (IOException e) {
            Err.show(e);
            throw new ExtError(cr, "File-Move-Error", "Can't move \"" + source.toFile().getAbsolutePath() + "\" --> \"" + target.getAbsolutePath() + '\"');
        }
    }

    private JMo_File create(CallRuntime cr) {
        cr.args();
        boolean ok = false;
        try {
            File f = this.getInternalFile();
            if (f.exists()) {
                throw new ExtError(cr, "Can't create File", "File already exists: " + this.getInternalFile().getAbsolutePath());
            }
            ok = f.createNewFile();
        }
        catch (IOException e) {
            ok = false;
        }
        if (!ok) {
            throw new ExtError(cr, "Can't create File", this.getInternalFile().getAbsolutePath());
        }
        return this;
    }

    private JMo_File clear(CallRuntime cr) {
        cr.args();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.getInternalFile(), "rw");
            raf.setLength(0L);
            JMo_File jMo_File = this;
            return jMo_File;
        }
        catch (Exception err) {
            throw new ExtError(cr, "File access error", this.getInternalFile().getAbsolutePath());
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                throw new ExtError(cr, "File close error", this.getInternalFile().getAbsolutePath());
            }
        }
    }

    private JMo_Long getSize(CallRuntime cr) {
        cr.args();
        return new JMo_Long(this.getInternalFile().length());
    }

    private JMo_DateTime getDateModify(CallRuntime cr) {
        cr.args();
        long l = this.getInternalFile().lastModified();
        return new JMo_DateTime(new MDateTime(l));
    }

    private JMo_DateTime getDateCreate(CallRuntime cr) {
        BasicFileAttributes attr;
        cr.args();
        try {
            attr = Files.readAttributes(this.getInternalFile().toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ExtError(cr, "File-Read-Error", e.getMessage());
        }
        long l = attr.creationTime().toMillis();
        return new JMo_DateTime(new MDateTime(l));
    }

    private Str getSuffix(CallRuntime cr) {
        cr.args();
        String suffix = Lib_FileSys.getSuffix(this.getInternalFile());
        return new Str(suffix);
    }

    private JMo_Dir getDir(CallRuntime cr) {
        cr.args();
        String path = this.getInternalFile().getParent();
        return new JMo_Dir(new File(path));
    }

    private JMo_File open(CallRuntime cr) {
        cr.args();
        try {
            Lib_FileSys.start(this.getInternalFile());
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create File", this.getInternalFile().getAbsolutePath());
        }
        return this;
    }

    private Str read(CallRuntime cr) {
        cr.args();
        try {
            String content = Lib_TextFile.read(this.getInternalFile(), true);
            return new Str(content);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getMessage());
        }
    }

    private JMo_List readLines(CallRuntime cr) {
        cr.args(this, new Class[0]);
        ArrayList<I_Object> list = this.iReadLines(cr);
        return new JMo_List(list);
    }

    private ArrayList<I_Object> iReadLines(CallRuntime cr) {
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        try {
            I_List<String> lines = Lib_TextFile.readLines(this.getInternalFile(), true);
            for (String line : lines) {
                list.add(new Str(line));
            }
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File read error", e.getMessage());
        }
        return list;
    }

    private JMo_File append(CallRuntime cr) {
        I_Object o = cr.args(this, A_Atomic.class)[0];
        String s = Lib_Convert.getStringValue(cr, o);
        try {
            Lib_TextFile.append(this.getInternalFile(), s, true);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getMessage());
        }
        return this;
    }

    private JMo_File write(CallRuntime cr) {
        I_Object[] oa = cr.argsFlex(this, 1, 2);
        I_Object so = cr.argType(oa[0], A_Atomic.class);
        String s = Lib_Convert.getStringValue(cr, so);
        try {
            if (oa.length == 1) {
                Lib_TextFile.set(this.getInternalFile(), s, true);
            } else {
                I_Object po = cr.argType(oa[1], A_IntNumber.class);
                int p = Lib_Convert.getIntValue(cr, po);
                Lib_Error.ifTooSmall(cr, 1L, p);
                Lib_TextFile.set(this.getInternalFile(), (long)p - 1L, s, true);
            }
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "File-Access-Error", e.getLocalizedMessage());
        }
        return this;
    }
}

