/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.StrictManager;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_DecNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public class Dec
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    private final double value;

    public Dec(double val) {
        this.value = StrictManager.limitDec() ? Lib_Math.normalize(val, 12) : val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.DEC, to, this, this.getValue());
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Dec(-this.value - 1.0);
            }
            case ABS: {
                return new Dec(Math.abs(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] args) {
        if (args.length == 0) {
            switch (op) {
                case INC: {
                    return new Dec(this.value + 1.0);
                }
                case DEC: {
                    return new Dec(this.value - 1.0);
                }
                case POW: {
                    return new Dec(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
        } else {
            A_Number parn = (A_Number)cr.argType(args[0], A_Number.class);
            double arg = Lib_Convert.getDoubleValue(cr, parn);
            switch (op) {
                case INC: {
                    return new Dec(this.value + arg);
                }
                case DEC: {
                    return new Dec(this.value - arg);
                }
                case POW: {
                    return new Dec(Math.pow(this.value, arg));
                }
                case SQR: {
                    return new Dec(Math.exp(Math.log(this.value) / arg));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + args.length);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number parn) {
        double val = this.value;
        double arg = Lib_Convert.getDoubleValue(cr, parn);
        switch (op) {
            case ADD: {
                return new Dec(val + arg);
            }
            case SUB: {
                return new Dec(val - arg);
            }
            case MUL: {
                return new Dec(val * arg);
            }
            case DIV: {
                if (arg == 0.0) {
                    throw new ExecError(cr, "Division by zero", val + "/" + arg);
                }
                return new Dec(val / arg);
            }
            case MOD: {
                return new Dec(val % arg);
            }
            case LOG: {
                return new Dec(Math.log(val) / Math.log(arg));
            }
        }
        throw new CodeError(cr, "Unknown type or function", (Object)((Object)op) + " " + Lib_Type.getName(parn));
    }
}

