/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.COMPARE;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_StrFormat;

public abstract class A_Atomic
extends A_Object
implements I_AtomicValue {
    @Override
    public final void init(CallRuntime cr) {
    }

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "len": 
            case "getLength": {
                return A_Object.stdResult(this.length(cr));
            }
            case "toBoolean": 
            case "toBool": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.BOOL));
            }
            case "toChar": 
            case "toCharacter": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.CHAR));
            }
            case "toDecimal": 
            case "toDec": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.DEC));
            }
            case "toInt": 
            case "toInteger": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.INT));
            }
            case "format": {
                return A_Object.stdResult(this.format(cr));
            }
            case "toByte": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.BYTE));
            }
            case "toShort": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.SHORT));
            }
            case "toLong": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.LONG));
            }
            case "toFloat": {
                cr.args();
                return A_Object.stdResult(this.convertTo(cr, ATOMIC.FLOAT));
            }
            case "toJava": {
                cr.args();
                return A_Object.stdResult(this.toJava(cr));
            }
            case "if": {
                return this.doIf(cr, false, false, false);
            }
            case "ifNot": {
                return this.doIf(cr, true, false, false);
            }
            case "at": 
            case "is": {
                return this.doIf(cr, false, false, true);
            }
            case "atNot": 
            case "isNot": {
                return this.doIf(cr, true, false, true);
            }
            case "passIf": {
                return this.doIf(cr, false, true, false);
            }
            case "passIfNot": {
                return this.doIf(cr, true, true, false);
            }
            case "passAt": 
            case "passIs": {
                return this.doIf(cr, false, true, true);
            }
            case "passAtNot": 
            case "passIsNot": {
                return this.doIf(cr, true, true, true);
            }
            case "breakAt": 
            case "breakIs": {
                return this.breakAt(cr);
            }
            case "breakAtNot": 
            case "breakIsNot": {
                return this.breakAtNot(cr);
            }
            case "breakIf": {
                return this.breakIf(cr, false);
            }
            case "breakIfNot": {
                return this.breakIf(cr, true);
            }
            case "isLess": 
            case "<": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.L));
            }
            case "isGreater": 
            case ">": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.G));
            }
            case "<=": 
            case "isLessOrEqual": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.LE));
            }
            case "isGreaterOrEqual": 
            case ">=": {
                return A_Object.stdResult(this.comparsion(cr, COMPARE.GE));
            }
            case "->": 
            case "keyValue": {
                return A_Object.stdResult(this.keyvalue(cr));
            }
        }
        return this.call3(cr, method);
    }

    private I_Object keyvalue(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return new JMo_KeyValue(this, o);
    }

    protected abstract ObjectCallResult call3(CallRuntime var1, String var2);

    protected abstract Int length(CallRuntime var1);

    protected JMo_Java toJava(CallRuntime cr) {
        return new JMo_Java(this.getValue());
    }

    protected ObjectCallResult breakAt(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            if (this.equals(arg)) {
                Return rb = new Return(Return.LEVEL.BREAK, this);
                return new ObjectCallResult(rb, true);
            }
            ++n2;
        }
        I_Object result = Lib_Exec.execBlockStream(cr, this);
        return new ObjectCallResult(result, true);
    }

    protected ObjectCallResult breakAtNot(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        boolean valid = false;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            if (this.equals(arg)) {
                valid = true;
                break;
            }
            ++n2;
        }
        if (valid) {
            I_Object result = Lib_Exec.execBlockStream(cr, this);
            return new ObjectCallResult(result, true);
        }
        Return rb = new Return(Return.LEVEL.BREAK, this);
        return new ObjectCallResult(rb, true);
    }

    protected ObjectCallResult breakIf(CallRuntime cr, boolean not) {
        Bool arg = (Bool)cr.argsEach(this, 0, new I_Object[]{this}, Bool.class);
        if (not ? arg == Bool.FALSE : arg == Bool.TRUE) {
            Return rb = new Return(Return.LEVEL.BREAK, this);
            return new ObjectCallResult(rb, true);
        }
        I_Object result = Lib_Exec.execBlockStream(cr, this);
        return new ObjectCallResult(result, true);
    }

    public ObjectCallResult doIf(CallRuntime cr, boolean not, boolean passToStream, boolean equals) {
        I_Object[] args = equals ? cr.argsVar(this, 1, 0) : cr.argsFlex(this, 0, 1);
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (args != null && args.length == 0) {
            args = null;
        }
        if (args == null && stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean check = false;
        if (equals) {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                A_Atomic par0 = (A_Atomic)cr.argType(arg, A_Atomic.class);
                check = this.getValue().equals(par0.getValue());
                if (!check) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            I_Object base = this;
            if (args != null && args.length == 1) {
                base = cr.argType(args[0], Bool.class);
            } else if (!(this instanceof Bool)) {
                throw new ExecError(cr, "Invalid type of object for if-function", "Type must be <Bool>, but is: " + this.getType(cr).toString());
            }
            check = ((Bool)base).getValue();
        }
        if (not) {
            check = !check;
        }
        I_Object res = passToStream ? this : Bool.getObject(check);
        res = Lib_Exec.execIf(cr, check, res, passToStream);
        return new ObjectCallResult(res, true);
    }

    private Str format(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String format = Lib_Convert.getStringValue(cr, arg);
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < format.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(format, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, this));
        }
        return new Str(sb.toString());
    }

    @Override
    public boolean equalsStrict(Object arg) {
        if (this == Nil.NIL || arg == Nil.NIL) {
            return this == arg;
        }
        if (!(arg instanceof I_AtomicValue)) {
            return false;
        }
        arg = ((I_AtomicValue)arg).getValue();
        Object cur = this.getValue();
        if (arg.getClass() != cur.getClass()) {
            return false;
        }
        if (cur instanceof Double && Double.isNaN((Double)cur) && arg instanceof Double && Double.isNaN((Double)arg)) {
            return true;
        }
        return cur.equals(arg);
    }

    @Override
    public boolean equals(Object arg) {
        Object cur;
        if (this == Nil.NIL || arg == Nil.NIL) {
            return this == arg;
        }
        if (arg instanceof I_AtomicValue) {
            arg = ((I_AtomicValue)arg).getValue();
        }
        if ((cur = this) instanceof I_AtomicValue) {
            cur = ((I_AtomicValue)cur).getValue();
        }
        if (cur instanceof Number && arg instanceof Number) {
            if (cur instanceof Double && Double.isNaN((Double)cur) && arg instanceof Double && Double.isNaN((Double)arg)) {
                return true;
            }
            return ((Number)cur).doubleValue() == ((Number)arg).doubleValue();
        }
        if ((cur instanceof Character || cur instanceof String) && (arg instanceof Character || arg instanceof String)) {
            return cur.toString().equals(arg.toString());
        }
        return cur.equals(arg);
    }

    @Override
    public boolean equalsLazy(Object objPar) {
        String strCurLower;
        Object objCur;
        if (this == Nil.NIL || objPar == Nil.NIL) {
            return this == objPar;
        }
        if (objPar instanceof I_AtomicValue) {
            objPar = ((I_AtomicValue)objPar).getValue();
        }
        if (objPar.equals(objCur = this.getValue())) {
            return true;
        }
        if ((objPar instanceof Boolean || objPar instanceof Number) && (objCur instanceof Boolean || objCur instanceof Number)) {
            Number numCur;
            Number numPar;
            Number number = objPar instanceof Boolean ? (Number)((Boolean)objPar != false ? 1 : 0) : (Number)(numPar = (Number)objPar);
            Number number2 = objCur instanceof Boolean ? (Number)((Boolean)objCur != false ? 1 : 0) : (Number)(numCur = (Number)objCur);
            if (objCur instanceof Double && Double.isNaN((Double)objCur) && objPar instanceof Double && Double.isNaN((Double)objPar)) {
                return true;
            }
            return numCur.doubleValue() == numPar.doubleValue();
        }
        String strPar = objPar.toString();
        String strCur = objCur.toString();
        String strParLower = strPar.toLowerCase();
        if (strParLower.equals("true")) {
            strPar = "1";
        }
        if (strParLower.equals("false")) {
            strPar = "0";
        }
        if ((strCurLower = strCur.toLowerCase()).equals("true")) {
            strCur = "1";
        }
        if (strCurLower.equals("false")) {
            strCur = "0";
        }
        if (strCur.endsWith(".0")) {
            strCur = strCur.substring(0, strCur.length() - 2);
        }
        if (strPar.endsWith(".0")) {
            strPar = strPar.substring(0, strPar.length() - 2);
        }
        return strPar.equals(strCur);
    }

    protected abstract Bool comparsion(CallRuntime var1, COMPARE var2);

    @Override
    public final Integer compareTo2(I_Object o) {
        if (!(o instanceof I_AtomicValue)) {
            return null;
        }
        Integer result = this.compareTo3((I_AtomicValue)o);
        return result != null ? result : null;
    }

    protected abstract Integer compareTo3(I_AtomicValue var1);
}

