/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jmo_lang.core.MethodList;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;

public abstract class A_AutoObject
extends A_Object {
    private Method[] map = null;

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        this.iInit();
        Object[] pa = cr.argsVar(this, 0, 0);
        Method met = this.iMethod(cr, method, pa);
        if (met == null) {
            return null;
        }
        try {
            I_Object res = null;
            if (pa != null && pa.length > 0) {
                Object[] args = new Object[pa.length];
                int i = 0;
                while (i < args.length) {
                    args[i] = pa[i];
                    ++i;
                }
                res = (I_Object)met.invoke((Object)this, args);
            } else {
                res = (I_Object)met.invoke((Object)this, new Object[0]);
            }
            if (res == null) {
                res = this;
            }
            return new ObjectCallResult(res, false);
        }
        catch (ErrorBase e) {
            throw new ExecError(cr, e.getMessage(), e.getDetail());
        }
        catch (IllegalAccessException e) {
            Err.exit(e);
        }
        catch (IllegalArgumentException e) {
            Err.exit(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ErrorBase) {
                throw new ExecError(cr, cause.getMessage(), ((ErrorBase)cause).getDetail());
            }
            if (cause instanceof ErrorBaseDebug) {
                throw (ErrorBaseDebug)cause;
            }
            Err.exit(e, cr.getDebugInfo().toString());
        }
        return null;
    }

    public void getMethods(MethodList ml) {
        this.iInit();
        Method[] methodArray = this.map;
        int n = this.map.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String name = m.getName();
            Class<?> res = m.getReturnType();
            ml.add(res, name, m.getParameterTypes());
            ++n2;
        }
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.getTypeName();
    }

    private Method iMethod(CallRuntime cr, String name, Object[] args) {
        Err.ifNull(name);
        int parlen = args.length;
        Method[] methodArray = this.map;
        int n = this.map.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                Class<?>[] mpars = m.getParameterTypes();
                if (m.getParameterCount() == parlen) {
                    boolean ok = true;
                    int i = 0;
                    while (i < mpars.length) {
                        if (!mpars[i].isInstance(args[i])) {
                            MOut.exit(name, i, mpars[i], args[i].getClass());
                            ok = false;
                            break;
                        }
                        ++i;
                    }
                    if (ok) {
                        return m;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private void iInit() {
        if (this.map == null) {
            ArrayList<Method> ml = new ArrayList<Method>();
            Class<?> c = this.getClass();
            while (c != null && c != A_AutoObject.class) {
                Method[] ma;
                Method[] methodArray = ma = c.getDeclaredMethods();
                int n = ma.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (Modifier.isPublic(m.getModifiers())) {
                        ml.add(m);
                    }
                    ++n2;
                }
                c = c.getSuperclass();
            }
            this.map = ml.toArray(new Method[ml.size()]);
        }
    }
}

