/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.tcp;

import de.mn77.base.error.Err;
import de.mn77.lib.tcp.TCP_Client;
import de.mn77.lib.tcp.TCP_Connection;
import java.io.IOException;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.lib.tcp.JMo_TcpConnection;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_TcpClient
extends A_EventObject {
    private TCP_Client client;
    private final ArgCallBuffer par_address;
    private final ArgCallBuffer par_port;

    public JMo_TcpClient(Call address, Call port) {
        this.par_address = new ArgCallBuffer(1, address);
        this.par_port = new ArgCallBuffer(2, port);
    }

    @Override
    public void init(CallRuntime cr) {
        String address = Lib_Convert.getStringValue(cr, this.par_address.init(cr, this, Str.class));
        int port = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.client = new TCP_Client(address, port);
        }
        catch (IOException e) {
            Err.exit(e);
        }
        this.client.onTimeOut(ste -> {
            JMo_Error e = new JMo_Error((Throwable)ste);
            this.eventRun(cr, "@timeout", e);
        });
        this.client.onError(ioe -> {
            JMo_Error e = new JMo_Error((Throwable)ioe);
            this.eventRun(cr, "@error", e);
        });
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "connect": {
                TCP_Connection con = this.client.connect();
                return A_Object.stdResult(con == null ? Nil.NIL : new JMo_TcpConnection(con));
            }
        }
        return null;
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@timeout": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(\"" + this.par_address.get() + "\":" + this.par_port.get() + ")";
    }
}

