/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.lib.swing.A_Swing_Object;
import org.jmo_lang.lib.swing.I_SwingObj;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.tools.Lib_Convert;

public abstract class A_Swing_Frame
extends A_Swing_Object {
    private final ArgCallBuffer par_dx;
    private final ArgCallBuffer par_dy;
    private final ArgCallBuffer par_title;
    protected final JFrame frame;
    private boolean closed = false;

    public A_Swing_Frame() {
        this(null, null, null);
    }

    public A_Swing_Frame(Call title) {
        this(null, null, title);
    }

    public A_Swing_Frame(Call dx, Call dy) {
        this(dx, dy, null);
    }

    public A_Swing_Frame(Call dx, Call dy, Call title) {
        this.par_dx = dx == null ? null : new ArgCallBuffer(1, dx);
        this.par_dy = dy == null ? null : new ArgCallBuffer(2, dy);
        this.par_title = title == null ? null : new ArgCallBuffer(3, title);
        this.frame = new JFrame();
        GridLayout l = new GridLayout(0, 1);
        this.frame.setLayout(l);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/icon/jmo256.png"));
        this.frame.setIconImage(img.getImage());
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par_dx != null && this.par_dy != null) {
            int width = Lib_Convert.getIntValue(cr, this.par_dx.init(cr, this, A_IntNumber.class));
            int height = Lib_Convert.getIntValue(cr, this.par_dy.init(cr, this, A_IntNumber.class));
            this.frame.setSize(width, height);
        }
        if (this.par_title != null) {
            String title = Lib_Convert.getStringValue(cr, this.par_title.init(cr, this, Str.class));
            this.frame.setTitle(title);
        }
    }

    @Override
    protected final I_Object callMethod2(CallRuntime cr, String method) {
        if (this.closed) {
            throw new ExecError(cr, "Illegal Frame-Access", "This Frame is already closed");
        }
        switch (method) {
            case "close": {
                cr.args();
                this.frame.dispose();
                this.closed = true;
                return Nil.NIL;
            }
            case "maximize": {
                cr.args();
                this.frame.setExtendedState(this.frame.getExtendedState() | 6);
                return this;
            }
            case "+": 
            case "add": {
                I_SwingObj o;
                I_SwingObj b = o = (I_SwingObj)cr.args(this, I_SwingObj.class)[0];
                this.frame.getContentPane().add(b.getSwing());
                return this;
            }
            case "setSize": {
                this.size(cr, SIZE.CURRENT);
                return this;
            }
            case "setSizeMin": {
                this.size(cr, SIZE.MIN);
                return this;
            }
            case "setTitle": {
                String title = Lib_Convert.getStringValue(cr, cr.args(this, Str.class)[0]);
                this.frame.setTitle(title);
                return this;
            }
            case "pack": {
                cr.args();
                this.frame.pack();
                return this;
            }
        }
        return this.callMethod3(cr, method);
    }

    protected abstract I_Object callMethod3(CallRuntime var1, String var2);

    private A_Swing_Frame size(CallRuntime cr, SIZE s) {
        I_Object[] args = cr.args(this, Int.class, Int.class);
        int dx = Lib_Convert.getIntValue(cr, args[0]);
        int dy = Lib_Convert.getIntValue(cr, args[1]);
        if (dx <= 0 || dy <= 0) {
            throw new ExecError(cr, "Value out of bounds", "Minimum of 1 useful, got " + dx + "/" + dy);
        }
        switch (s) {
            case CURRENT: {
                this.frame.setSize(dx, dy);
                break;
            }
            case MIN: {
                this.frame.setMinimumSize(new Dimension(dx, dy));
                break;
            }
            case MAX: {
                this.frame.setMaximumSize(new Dimension(dx, dy));
            }
        }
        return this;
    }

    @Override
    public Component getSwing() {
        return this.frame;
    }

    private static enum SIZE {
        CURRENT,
        MIN,
        MAX;

    }
}

