/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.graphic;

import de.mn77.base.data.numsys.Hex;
import de.mn77.base.error.Err;
import java.awt.Color;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.lib.graphic.A_ColorSpace;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class JMo_ColorRGB
extends A_ColorSpace {
    private final ArgCallBuffer par1;
    private final ArgCallBuffer par2;
    private final ArgCallBuffer par3;
    private Color color = null;

    public JMo_ColorRGB() {
        this(0, 0, 0);
    }

    public JMo_ColorRGB(int r, int g, int b) {
        this.par1 = null;
        this.par2 = null;
        this.par3 = null;
        this.color = new Color(r, g, b);
    }

    public JMo_ColorRGB(Color c) {
        this.par1 = null;
        this.par2 = null;
        this.par3 = null;
        this.color = c;
    }

    public JMo_ColorRGB(Call p1, Call p2, Call p3) {
        this.par1 = new ArgCallBuffer(1, p1);
        this.par2 = new ArgCallBuffer(2, p2);
        this.par3 = new ArgCallBuffer(3, p3);
    }

    public JMo_ColorRGB(Call p1) {
        this.par1 = new ArgCallBuffer(1, p1);
        this.par2 = null;
        this.par3 = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.color != null) {
            return;
        }
        if (this.par1 != null && this.par2 != null && this.par3 != null) {
            I_Object po1 = this.par1.init(cr, this, A_IntNumber.class);
            I_Object po2 = this.par2.init(cr, this, A_IntNumber.class);
            I_Object po3 = this.par3.init(cr, this, A_IntNumber.class);
            int pi1 = Lib_Convert.getIntValue(cr, po1);
            int pi2 = Lib_Convert.getIntValue(cr, po2);
            int pi3 = Lib_Convert.getIntValue(cr, po3);
            Lib_Error.ifNotBetween(cr, 0, 255, pi1, "Value for red");
            Lib_Error.ifNotBetween(cr, 0, 255, pi2, "Value for green");
            Lib_Error.ifNotBetween(cr, 0, 255, pi3, "Value for blue");
            this.color = new Color(pi1, pi2, pi3);
        } else if (this.par1 != null && this.par2 == null && this.par3 == null) {
            I_Object po1 = this.par1.init(cr, this, Str.class);
            String ps = Lib_Convert.getStringValue(cr, po1);
            if (ps.length() != 7 && ps.length() != 4 || ps.charAt(0) != '#') {
                throw new ExecError(cr, "Invalid html color", "Need something like '#fff' or '#000000', but got: " + ps);
            }
            int r = 0;
            int g = 0;
            int b = 0;
            if (ps.length() == 7) {
                r = Integer.parseInt(ps.substring(1, 3), 16);
                g = Integer.parseInt(ps.substring(3, 5), 16);
                b = Integer.parseInt(ps.substring(5, 7), 16);
            } else {
                r = Integer.parseInt(ps.substring(1, 2), 16);
                r = r * 16 + r;
                g = Integer.parseInt(ps.substring(2, 3), 16);
                g = g * 16 + g;
                b = Integer.parseInt(ps.substring(3, 4), 16);
                b = b * 16 + b;
            }
            this.color = new Color(r, g, b);
        } else {
            Err.invalid(this.par1, this.par2, this.par3);
        }
    }

    @Override
    protected I_Object call4(CallRuntime cr, String method) {
        switch (method) {
            case "getRed": {
                cr.args();
                return new Int(this.color.getRed());
            }
            case "getGreen": {
                cr.args();
                return new Int(this.color.getGreen());
            }
            case "getBlue": {
                cr.args();
                return new Int(this.color.getBlue());
            }
            case "toHtml": 
            case "html": {
                return this.html(cr);
            }
        }
        return null;
    }

    public Str html(CallRuntime cr) {
        cr.args();
        String s = "#" + Hex.toHex(this.color.getRed()) + Hex.toHex(this.color.getGreen()) + Hex.toHex(this.color.getBlue());
        return new Str(s.toLowerCase());
    }

    @Override
    public String toString() {
        return String.valueOf(Lib_Type.getName(this)) + "(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")";
    }

    @Override
    public Color getColor() {
        return this.color;
    }
}

