/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.FunctionPar;
import org.jmo_lang.core.MultiCallItems;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.VarEnv;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;

public class VarConstEnv {
    private static int counter = 0;
    private final int nr;
    public final VarEnv vars;
    public final VarEnv cons;
    private final VarConstEnv parent;
    private MultiCallItems multicall = null;
    private LoopHandle loop = null;
    private Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> funcInitData = null;
    private Group2<CallRuntime, CallRuntime> initType = null;
    private LoopHandle childLoop = null;

    public VarConstEnv(VarConstEnv parent) {
        this.parent = parent;
        VarEnv parentVars = parent == null ? null : parent.vars;
        VarEnv parentCons = parent == null ? null : parent.cons;
        this.vars = new VarEnv(parentVars, false);
        this.cons = new VarEnv(parentCons, true);
        this.nr = ++counter;
        if (parent != null && parent.childLoop != null) {
            this.loop = parent.childLoop;
        }
    }

    public VarConstEnv(VarEnv vars, VarEnv cons, VarConstEnv parent) {
        this.parent = parent;
        this.vars = vars;
        this.cons = cons;
        this.nr = ++counter;
        if (parent != null && parent.childLoop != null) {
            this.loop = parent.childLoop;
        }
    }

    public MultiCallItems useMultiCall() {
        if (this.multicall == null && this.parent != null) {
            this.multicall = this.parent.useMultiCall();
        }
        if (this.multicall == null) {
            this.multicall = new MultiCallItems();
        }
        return this.multicall;
    }

    public void loopSet(LoopHandle handle) {
        if (this.loop != null) {
            Err.invalid("Loop is already set!");
        }
        this.loop = handle;
    }

    public LoopHandle loopGet(CallRuntime cr) {
        if (this.loop != null) {
            return this.loop;
        }
        if (this.parent != null) {
            return this.parent.loopGet(cr);
        }
        throw new CodeError(cr, "Unknown loop!", "There's no loop known, in this and the parent blocks");
    }

    public void setFuncInit(Block block, CallRuntime cpOutside, CallRuntime crNew, FunctionPar[] vars) {
        this.funcInitData = new Group4<Block, CallRuntime, CallRuntime, FunctionPar[]>(block, cpOutside, crNew, vars);
    }

    public void setChildLoop(LoopHandle handle) {
        this.childLoop = handle;
    }

    public Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> getFuncInit(CallRuntime cr) {
        if (this.funcInitData != null) {
            return this.funcInitData;
        }
        if (this.parent != null) {
            return this.parent.getFuncInit(cr);
        }
        throw Err.invalid("There's no data to initialize!");
    }

    public void initTypeSet(CallRuntime crOld, CallRuntime cpNew2) {
        this.initType = new Group2<CallRuntime, CallRuntime>(crOld, cpNew2);
    }

    public Group2<CallRuntime, CallRuntime> initTypeGet() {
        VarConstEnv cur = this;
        while (cur.initType == null && cur.parent != null) {
            cur = cur.parent;
        }
        return cur.initType;
    }

    public VarConstEnv getParent() {
        return this.parent;
    }

    public String toString() {
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent.toString();
        return "VCE" + this.nr + sp;
    }

    public VarConstEnv copyForEventHandler(String[] varNamesToCopy, DebugInfo debug) {
        VarEnv v = new VarEnv(null, false);
        if (varNamesToCopy != null) {
            String[] stringArray = varNamesToCopy;
            int n = varNamesToCopy.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Group2<String, I_Object> g = this.vars.getToCopy(name, debug);
                v.setCopy(name, g);
                ++n2;
            }
        }
        return new VarConstEnv(v, this.cons, null);
    }
}

