/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.A_DataType;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_WorldTime;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.data.type.datetime.format.FORM_WORLDTIME;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.GregorianCalendar;

public class MWorldTime
extends A_DataType<I_WorldTime>
implements I_WorldTime {
    private final I_DateTime datetime;
    private final int utc_offset_msek;

    public MWorldTime() {
        this.datetime = new MDateTime();
        GregorianCalendar gc = new GregorianCalendar();
        this.utc_offset_msek = gc.get(15) + gc.get(16);
    }

    public MWorldTime(I_DateTime zeitpunkt, int utc_offset_std) {
        Err.ifNull(zeitpunkt);
        this.datetime = zeitpunkt;
        Err.ifOutOfBounds(12.0, utc_offset_std);
        this.utc_offset_msek = utc_offset_std * 60 * 60 * 1000;
    }

    public MWorldTime(String text) {
        block19: {
            Err.ifEmpty(text);
            int laenge = text.length();
            Err.ifOutOfBounds(14.0, 31.0, laenge);
            try {
                if (laenge >= 29 && laenge <= 31 && text.matches("^[A-Z][a-z]{2}, [0-9]{2} [A-Z][a-z]{2} [0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2} .*$")) {
                    Integer m;
                    Integer h;
                    Integer monat = Lib_DateTime.parseMonth(FilterString.cut(9, 3, text));
                    if (monat == null) {
                        Err.invalid("Unknown month", FilterString.cut(9, 3, text));
                    }
                    MDate datum = new MDate(Integer.parseInt(FilterString.cut(6, 2, text)), monat, Integer.parseInt(FilterString.cut(13, 4, text)));
                    MTime uhrzeit = new MTime(FilterString.cut(18, 8, text));
                    this.datetime = new MDateTime(datum, uhrzeit);
                    String rest = FilterString.cut(27, false, text);
                    if (rest.length() == 5 && rest.matches("^[\\+-][0-9]{4}$")) {
                        if (rest.charAt(0) != '+') {
                            Err.todo(new Object[0]);
                        }
                        h = Integer.parseInt(FilterString.cut(2, 2, rest));
                        m = Integer.parseInt(FilterString.cut(4, 2, rest));
                    } else if (rest.length() == 4 && rest.matches("^[0-9]{4}$")) {
                        h = Integer.parseInt(FilterString.cut(1, 2, rest));
                        m = Integer.parseInt(FilterString.cut(3, 2, rest));
                    } else if (rest.toUpperCase().equals("GMT")) {
                        h = 0;
                        m = 0;
                    } else if (rest.toUpperCase().equals("CEST")) {
                        h = 2;
                        m = 0;
                    } else if (rest.toUpperCase().equals("CET")) {
                        h = 1;
                        m = 0;
                    } else {
                        throw Err.invalid("Unknown time format!", text);
                    }
                    this.utc_offset_msek = (m + h * 60) * 60 * 1000;
                    break block19;
                }
                if (text.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[\\+-][0-9]{2}:[0-9]{2}")) {
                    MDateTime zp = new MDateTime(text.replaceFirst("T", " ").substring(0, 19));
                    this.datetime = zp;
                    if (text.charAt(19) != '+') {
                        Err.todo(new Object[0]);
                    }
                    Integer h = Integer.parseInt(FilterString.cut(21, 2, text));
                    Integer m = Integer.parseInt(FilterString.cut(24, 2, text));
                    this.utc_offset_msek = (m + h * 60) * 60 * 1000;
                    break block19;
                }
                if (text.matches("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}")) {
                    MDateTime zp = new MDateTime(text);
                    this.datetime = zp;
                    GregorianCalendar gc = new GregorianCalendar(zp.getYear(), zp.getMonth() - 1, zp.getDay(), zp.getHours(), zp.getMinutes(), zp.getSeconds());
                    this.utc_offset_msek = gc.get(15) + gc.get(16);
                    break block19;
                }
                throw Err.invalid("Unknown time format!", text);
            }
            catch (Err_Runtime f) {
                throw f;
            }
            catch (Exception e) {
                throw e;
            }
        }
    }

    @Override
    public I_DateTime getDateTime() {
        return this.datetime;
    }

    @Override
    public int getDay() {
        return this.datetime.getDay();
    }

    @Override
    public int getMonth() {
        return this.datetime.getDay();
    }

    @Override
    public int getYear() {
        return this.datetime.getDay();
    }

    @Override
    public int getHours() {
        return this.datetime.getDay();
    }

    @Override
    public int getMinutes() {
        return this.datetime.getDay();
    }

    @Override
    public int getSeconds() {
        return this.datetime.getDay();
    }

    @Override
    public int getDayOfWeek() {
        return this.datetime.getDayOfWeek();
    }

    @Override
    public int getUTC_Offset_MSek() {
        return this.utc_offset_msek;
    }

    @Override
    public boolean isEqual(I_WorldTime zeit) {
        return this.datetime.isEqual(zeit.getDateTime()) && this.utc_offset_msek == zeit.getUTC_Offset_MSek();
    }

    @Override
    public boolean isGreater(I_WorldTime zeit) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public String toStringDefault() {
        return this.toStringRFC822();
    }

    @Override
    public String toStringRFC822() {
        return this.toString(FORM_WORLDTIME.GROUP_RFC822);
    }

    @Override
    public String toString() {
        return this.toStringDefault();
    }

    public String toString(Object ... format) {
        String result = "";
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                result = String.valueOf(result) + o;
            } else if (o instanceof FORM_DATE) {
                result = String.valueOf(result) + this.datetime.toString(o);
            } else if (o instanceof FORM_TIME) {
                result = String.valueOf(result) + this.datetime.toString(o);
            } else if (o == FORM_WORLDTIME.GMT_5) {
                int gmt_min = Lib_Math.absBetrag(this.utc_offset_msek) / 1000 / 60;
                result = String.valueOf(result) + (this.utc_offset_msek >= 0 ? "+" : "-");
                int h = gmt_min / 60;
                int m = gmt_min - h * 60;
                result = String.valueOf(result) + FormNumber.width(2, Lib_Math.roundDown(h), false);
                result = String.valueOf(result) + FormNumber.width(2, Lib_Math.roundDown(m), false);
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return result;
    }
}

