/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.search;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.struct.table.type.I_TypeTable;
import de.mn77.base.error.Err;

public class SearchTable {
    public static <T> I_Table<T> filter(I_Table<T> tab, int col, String regex, boolean case_sensitiv) {
        Err.ifNull(tab, regex);
        Err.ifOutOfBounds(1.0, tab.getWidth(), col);
        Err.ifToSmall(1.0, tab.getWidth());
        MTable result = new MTable(tab.getWidth());
        if (!case_sensitiv) {
            regex = "(?i)" + regex;
        }
        for (I_Sequence i_Sequence : tab) {
            if (!("" + i_Sequence.get(col)).matches(regex)) continue;
            result.add(i_Sequence);
        }
        return result;
    }

    public static <TG> I_List<TG> filterColumn(I_TypeTable<TG, ?> tab, int col, String regex, boolean case_sensitiv) {
        Err.ifNull(tab, regex);
        Err.ifOutOfBounds(1.0, tab.getWidth(), col);
        Err.ifToSmall(1.0, tab.getWidth());
        MList result = new MList();
        if (!case_sensitiv) {
            regex = "(?i)" + regex;
        }
        int z = 1;
        while (z <= tab.size()) {
            String o = "" + tab.get(col, z);
            if (o.matches(regex)) {
                result.add(tab.get(z));
            }
            ++z;
        }
        return result;
    }
}

