/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.H_POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_StrFormat {
    private static final String REGEX = "^([1-9][0-9]*)?([!\\?]+)?([<>^])?([idcsb])?([0-9+^vcul]+)?$";

    public static String format(CallRuntime cr, String s, I_Object o) {
        int len = s.length();
        String os = Lib_Convert.getStringValue(cr, o);
        if (len == 2) {
            return os;
        }
        if (!(s = s.substring(1, len - 1)).matches(REGEX)) {
            throw new ExecError(cr, "Unknown format", s);
        }
        String sFieldLen = s.replaceFirst(REGEX, "$1");
        int field_len = sFieldLen.length() == 0 ? 0 : Integer.parseInt(sFieldLen);
        String sOverflow = s.replaceFirst(REGEX, "$2");
        boolean cutOverflow = sOverflow.length() == 0 ? false : sOverflow.equals("!");
        String sAlign = s.replaceFirst(REGEX, "$3");
        H_POSITION.H align = sAlign.equals("<") ? POSITION_H.LEFT : (sAlign.equals(">") ? POSITION_H.RIGHT : (sAlign.equals("^") ? POSITION_H.CENTER : null));
        String sType = s.replaceFirst(REGEX, "$4");
        Character type = Character.valueOf((char)(sType.length() > 0 ? sType.charAt(0) : (o instanceof Bool ? 98 : (o instanceof Char ? 99 : (o instanceof Dec ? 100 : (o instanceof Int ? 105 : (o instanceof JMo_Byte ? 105 : (o instanceof JMo_Float ? 100 : (o instanceof JMo_Long ? 105 : (o instanceof JMo_Short ? 105 : 115))))))))));
        String sSpec = s.replaceFirst(REGEX, "$5");
        switch (type.charValue()) {
            case 's': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                os = Lib_StrFormat.iSpecString(cr, os, sSpec);
                return FormString.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'c': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                os = Lib_StrFormat.iSpecChar(cr, o, sSpec);
                return FormString.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'i': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                os = Lib_StrFormat.iSpecInt(cr, o, sSpec);
                return FormString.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'd': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                os = Lib_StrFormat.iSpecDec(cr, o, sSpec);
                return FormString.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'b': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                os = Lib_StrFormat.iSpecBool(cr, o, sSpec);
                return FormString.width(field_len, ' ', os, align, cutOverflow);
            }
        }
        throw Err.todo(s, os, type);
    }

    public static final Group2<Boolean, String> getNext(String s, int offset) {
        boolean formatOpen = false;
        int pos = offset;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '{') {
                    if (pos == offset) {
                        formatOpen = true;
                    } else {
                        return new Group2<Boolean, String>(false, s.substring(offset, pos));
                    }
                }
                if (c == '}' && formatOpen) {
                    return new Group2<Boolean, String>(true, s.substring(offset, pos + 1));
                }
            }
            ++pos;
        }
        return new Group2<Boolean, String>(formatOpen, s.substring(offset));
    }

    private static String iSpecString(CallRuntime cr, String os, String sSpec) {
        if (sSpec.length() == 0) {
            return os;
        }
        if (!sSpec.matches("^[\\^cvul1234]?$")) {
            throw Lib_StrFormat.iSpecThrow(cr, "String", sSpec);
        }
        char c = sSpec.charAt(0);
        if (c == '^' || c == 'u') {
            return os.toUpperCase();
        }
        if (c == 'v' || c == 'l') {
            return os.toLowerCase();
        }
        if (c == 'c') {
            return Lib_String.capitalize(os);
        }
        if (c == '1') {
            return FormString.quote(os, '\'', '\\');
        }
        if (c == '2') {
            return FormString.quote(os, '\"', '\\');
        }
        if (c == '3') {
            return FormString.quote(os, '\'', '\'');
        }
        if (c == '4') {
            return FormString.quote(os, '\"', '\"');
        }
        throw Lib_StrFormat.iSpecThrow(cr, "String", sSpec);
    }

    private static String iSpecChar(CallRuntime cr, I_Object o, String sSpec) {
        String os = "" + Lib_Convert.getCharValue(cr, o, true);
        if (sSpec.length() == 0) {
            return os;
        }
        if (!sSpec.matches("^[\\^vul]?$")) {
            throw Lib_StrFormat.iSpecThrow(cr, "Character", sSpec);
        }
        char c = sSpec.charAt(0);
        if (c == '^' || c == 'u') {
            return os.toUpperCase();
        }
        if (c == 'v' || c == 'l') {
            return os.toLowerCase();
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Character", sSpec);
    }

    private static String iSpecInt(CallRuntime cr, I_Object o, String sSpec) {
        String os = "" + Lib_Convert.getIntValue(cr, o, false);
        if (sSpec.length() == 0) {
            return os;
        }
        if (!sSpec.matches("^[+]?$")) {
            throw Lib_StrFormat.iSpecThrow(cr, "Integer", sSpec);
        }
        if (sSpec.charAt(0) == '+') {
            return os.charAt(0) == '-' ? os : String.valueOf('+') + os;
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Integer", sSpec);
    }

    private static String iSpecDec(CallRuntime cr, I_Object o, String sSpec) {
        double d = Lib_Convert.getDoubleValue(cr, o);
        if (sSpec.length() == 0) {
            return "" + d;
        }
        if (!sSpec.matches("^[+]?[0-9]*$")) {
            throw Lib_StrFormat.iSpecThrow(cr, "Decimal", sSpec);
        }
        String sign = "";
        if (sSpec.charAt(0) == '+') {
            sign = d < 0.0 ? "" : "+";
            sSpec = sSpec.substring(1);
        }
        String os = "" + d;
        if (sSpec.equals("0")) {
            os = "" + Math.round(d);
        } else if (sSpec.length() > 0) {
            int digits = Integer.parseInt(sSpec);
            os = FormNumber.round(d, digits);
        }
        return String.valueOf(sign) + os;
    }

    private static String iSpecBool(CallRuntime cr, I_Object o, String sSpec) {
        boolean b = Lib_Convert.getBoolValue(cr, o);
        if (sSpec.length() == 0) {
            return "" + b;
        }
        if (!sSpec.matches("^[\\^cvul]?$")) {
            throw Lib_StrFormat.iSpecThrow(cr, "Bool", sSpec);
        }
        char c = sSpec.charAt(0);
        if (c == '^' || c == 'u') {
            return b ? "TRUE" : "FALSE";
        }
        if (c == 'v' || c == 'l') {
            return b ? "true" : "false";
        }
        if (c == 'c') {
            return b ? "True" : "False";
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Bool", sSpec);
    }

    private static ExecError iSpecThrow(CallRuntime cr, String type, String sSpec) {
        throw new ExecError(cr, "Invalid Secification for " + type + "-Format", sSpec);
    }
}

