/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.ConstLet;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class Lib_Arguments {
    public static void checkBlockNecessary(CallRuntime cr) {
        if (!cr.hasBlock()) {
            throw new CodeError(cr, "Invalid function-call", "Block needed for this function");
        }
    }

    public static void checkBlockForbidden(CallRuntime cr) {
        if (cr.hasBlock()) {
            throw new CodeError(cr, "Invalid function-call", "No Block allowed for this function");
        }
    }

    public static I_Object checkArgAdvance(CallRuntime cr, I_Object streamIt, int argIdx, Integer argAmount, Class<?> type, boolean isInstanceInit) {
        I_Object arg = cr.getArgAdvance(streamIt, argIdx);
        return Lib_Arguments.checkArg(cr, arg, type, argIdx, argAmount, isInstanceInit);
    }

    public static I_Object checkArg(CallRuntime cr, I_Object arg, Class<?> type, Integer argPos, Integer argAmount, boolean isInstanceInit) {
        I_Object autoVarConstLet = Lib_Arguments.iAutoVarConstLet(cr, arg, type);
        if (autoVarConstLet != null) {
            return autoVarConstLet;
        }
        I_Object parReal = Lib_Convert.getValue(cr, arg);
        if (type != null && !type.isAssignableFrom(parReal.getClass())) {
            throw Lib_Arguments.iCreateInvalidArgTypeError(cr, arg, Lib_Arguments.iTypelistToText(type), argPos, argAmount, isInstanceInit);
        }
        return parReal;
    }

    public static I_Object checkArgExt(CallRuntime cr, I_Object arg, Class<?>[] types, Integer argPos, Integer argAmount, boolean isInstanceInit) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            I_Object autoVarConstLet = Lib_Arguments.iAutoVarConstLet(cr, arg, t);
            if (autoVarConstLet != null) {
                return autoVarConstLet;
            }
            ++n2;
        }
        I_Object parReal = Lib_Convert.getValue(cr, arg);
        Class<?>[] classArray2 = types;
        int n3 = types.length;
        n = 0;
        while (n < n3) {
            Class<?> t = classArray2[n];
            if (t.isAssignableFrom(parReal.getClass())) {
                return parReal;
            }
            ++n;
        }
        throw Lib_Arguments.iCreateInvalidArgTypeError(cr, arg, Lib_Arguments.iTypelistToText(new Class[][]{types}), argPos, argAmount, isInstanceInit);
    }

    public static I_Object[] checkArgs(CallRuntime cr, I_Object streamIt, Class<?> ... types) {
        Err.ifNull(cr.call, types);
        if (types.length == 0) {
            if (cr.argCount() > 0) {
                throw new CodeError(cr, "Invalid number of arguments", "No arguments allowed");
            }
            return new I_Object[0];
        }
        I_Object[] args = cr.getArgs(streamIt);
        int oal = args.length;
        Lib_Error.ifArgs(oal, types.length, (Integer)types.length, cr, streamIt);
        int i = 0;
        while (i < oal) {
            args[i] = Lib_Arguments.checkArg(cr, args[i], types[i], i + 1, oal, false);
            ++i;
        }
        return args;
    }

    public static I_Object checkArgsEach(CallRuntime cr, I_Object streamIt, int argIdx, I_Object[] eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getArgsEach(streamIt, argIdx, eachIt);
        return Lib_Arguments.checkArg(cr, result, type, argIdx + 1, null, false);
    }

    public static I_Object checkArgEach(CallRuntime cr, I_Object streamIt, int argIdx, I_Object eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getArgEach(streamIt, argIdx, eachIt);
        return Lib_Arguments.checkArg(cr, result, type, argIdx + 1, null, false);
    }

    public static I_Object[] checkArgsExt(CallRuntime cr, I_Object streamIt, Class<?>[] ... types) {
        I_Object[] args = cr.getArgs(streamIt);
        Lib_Error.ifArgs(args.length, types.length, (Integer)types.length, cr, streamIt);
        int i = 0;
        while (i < args.length) {
            args[i] = Lib_Arguments.checkArgExt(cr, args[i], types[i], i + 1, args.length, false);
            ++i;
        }
        return args;
    }

    public static I_Object[] checkArgsFlex(CallRuntime cr, I_Object streamIt, int par_min, Integer par_max) {
        I_Object[] args = cr.getArgs(streamIt);
        int len = args.length;
        Lib_Error.ifArgs(len, par_min, par_max, cr, streamIt);
        int i = 0;
        while (i < len) {
            args[i] = Lib_Convert.getValue(cr, args[i]);
            ++i;
        }
        return args;
    }

    private static I_Object iAutoVarConstLet(CallRuntime cr, I_Object arg, Class<?> wantedType) {
        if (!cr.getStrict().isValid_AutoVarLet()) {
            return null;
        }
        if (wantedType == VarLet.class && arg instanceof Var) {
            return new VarLet((Var)arg);
        }
        if (wantedType == ConstLet.class && arg instanceof Const) {
            return new ConstLet((Const)arg);
        }
        return null;
    }

    private static String objTypesToText(CallRuntime cr, I_Object[] oa) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int ioa = 0;
        while (ioa < oa.length) {
            I_Object o = oa[ioa];
            if (ioa != 0) {
                sb.append(", ");
            }
            sb.append(Lib_Type.getTypeString(o));
            ++ioa;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String iTypelistToText(Class<?> type) {
        return Lib_Type.getTypeString(type, null);
    }

    private static String iTypelistToText(Class<?>[][] types) {
        boolean more;
        StringBuilder sb = new StringBuilder();
        boolean bl = more = types.length > 1;
        if (more) {
            sb.append("(");
        }
        int ica = 0;
        while (ica < types.length) {
            Class<?>[] ca = types[ica];
            if (ica != 0) {
                sb.append(", ");
            }
            sb.append('<');
            int i = 0;
            while (i < ca.length) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_Type.getName(ca[i], null));
                ++i;
            }
            sb.append('>');
            ++ica;
        }
        if (more) {
            sb.append(")");
        }
        return sb.toString();
    }

    private static CodeError iCreateInvalidArgTypeError(CallRuntime cr, I_Object arg, String type, Integer argPos, Integer argAmount, boolean isInstanceInit) {
        String m = cr.call.method;
        if (m != null && m.charAt(0) >= 'a' && m.charAt(0) <= 'z') {
            m = String.valueOf('.') + m;
        }
        String eTarget = isInstanceInit || m == null ? cr.call.object.getTypeName() : m;
        String eArg = argPos != null && (argAmount == null || argAmount > 1) ? " as argument " + argPos : "";
        String typeDebug = Lib_Type.toStringExtWithType(cr, arg);
        String eDet = "Got " + typeDebug + eArg + " for '" + eTarget + "', expected: " + type;
        return new CodeError(cr, "Invalid type of argument", eDet);
    }
}

