/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.func;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.group.Group2;
import java.util.ArrayList;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.tools.Lib_Comply;
import org.jmo_lang.tools.Lib_Parser;

public class ParseFunc_EventHandler
implements I_ParseFunc {
    @Override
    public boolean hits(char c0, String s) {
        return c0 == ':' && s.startsWith("::@");
    }

    @Override
    public Group2<Call, String> parse(Parser_Script parser, Block current, I_Object obj, String s) {
        int bracketIndex = s.indexOf(40);
        String eventName = bracketIndex == -1 ? s : s.substring(0, bracketIndex);
        Lib_Comply.checkEventName(eventName);
        Call c = new Call(current, obj, eventName, null, parser.getDebugInfo());
        if (bracketIndex > -1) {
            String args;
            String remTrimmed = s.substring(bracketIndex);
            String rem = remTrimmed.substring(1 + (args = Lib_Parser.group('(', ')', remTrimmed, parser.getDebugInfo())).length() + 1);
            if (rem.length() > 0) {
                throw new ParseError("Invalid event handler definition", "Got additional: " + rem, parser.getDebugInfo());
            }
            ArrayList<String> varNames = ConvString.toList(',', args);
            int size = varNames.size();
            String[] varsToCopy = new String[size];
            int i = 0;
            while (i < size) {
                varsToCopy[i] = varNames.get(i).trim();
                ++i;
            }
            String[] stringArray = varsToCopy;
            int n = varsToCopy.length;
            int n2 = 0;
            while (n2 < n) {
                String varName = stringArray[n2];
                if (!Lib_Comply.checkVarName(varName)) {
                    throw new ParseError("Invalid variable name", "Can't copy variable: '" + varName + "'", parser.getDebugInfo());
                }
                ++n2;
            }
            c.setEventCopyVars(varsToCopy);
        }
        return new Group2<Call, Object>(c, null);
    }
}

