/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.fdef;

import de.mn77.base.data.group.Group3;
import org.jmo_lang.core.Function;
import org.jmo_lang.core.FunctionPar;
import org.jmo_lang.core.Type;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.fdef.FunctionInfo;
import org.jmo_lang.parser.fdef.Lib_FDef;
import org.jmo_lang.tools.Lib_Comply;
import org.jmo_lang.tools.Lib_Parser;

public class ParseFDef {
    public Function parse(Parser_Script parser, Type type, String s) {
        FunctionInfo info = this.scan(parser, s);
        Group3<FunctionPar[], Integer, Boolean> pars_rem_varargs = Lib_Parser.getFunctionPars(parser, type.getBlock(), info.args, '(', ')');
        parser.app.strict.checkFuncResultType(info.returnType, info.names[0], parser.getDebugInfo());
        Function f = new Function(type, info.names, (FunctionPar[])pars_rem_varargs.o1, info.control, info.isPrivate, info.returnType, info.returnNil, parser.getDebugInfo());
        if (info.returnDef != null) {
            Lib_FDef.setReturnCall(info.returnDef, parser, f);
        }
        if (((Boolean)pars_rem_varargs.o3).booleanValue()) {
            f.setVarArgs();
        }
        return f;
    }

    private FunctionInfo scan(Parser_Script parser, String s) {
        boolean isControl = false;
        boolean returnNil = true;
        String[] names = null;
        String args = "";
        String returnType = null;
        String returnDef = null;
        PHASE phase = PHASE.NAMES;
        int start = 0;
        boolean nameLastIsSpace = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (phase) {
                case NAMES: {
                    if (c == '(') {
                        if (nameLastIsSpace) {
                            throw new ParseError("Invalid function definition", "Please remove whitespace(s) between function name and '('", parser.getDebugInfo());
                        }
                        names = Lib_FDef.toNames(parser, s.substring(start, i));
                        phase = PHASE.PARS;
                        start = i;
                        break;
                    }
                    if (c == '=') {
                        names = Lib_FDef.toNames(parser, s.substring(start, i));
                        phase = PHASE.RESULT;
                        start = i;
                        break;
                    }
                    if (nameLastIsSpace && c >= 'A' && c <= 'Z') {
                        names = Lib_FDef.toNames(parser, s.substring(start, i));
                        phase = PHASE.RETURNTYPE;
                        start = i;
                        break;
                    }
                    if (c == ' ') {
                        nameLastIsSpace = true;
                        break;
                    }
                    if (c == '\t') {
                        throw new ParseError("Invalid function definition", "Please remove tabulator after: " + s.substring(0, i), parser.getDebugInfo());
                    }
                    nameLastIsSpace = false;
                    break;
                }
                case PARS: {
                    if (c != ')') break;
                    args = s.substring(start, i + 1);
                    phase = PHASE.MODIF;
                    start = i + 1;
                    break;
                }
                case MODIF: {
                    if (c == '=') {
                        phase = PHASE.RESULT;
                        start = i;
                        break;
                    }
                    if (c == '?') {
                        isControl = true;
                        start = i + 1;
                    }
                    phase = PHASE.RETURNTYPE;
                    break;
                }
                case RETURNTYPE: {
                    if (c == ' ') break;
                    if (c == '=') {
                        phase = PHASE.RESULT;
                        start = i;
                        break;
                    }
                    if (c != '?') break;
                    returnNil = true;
                    returnType = s.substring(start, i);
                    if (returnType.endsWith(" ")) {
                        throw new ParseError("Invalid function definition", "Return type has spaces between name and modifier: " + returnType + '?', parser.getDebugInfo());
                    }
                    returnType = returnType.trim();
                    phase = PHASE.RESULT;
                    start = i + 1;
                }
            }
            ++i;
        }
        if (phase == PHASE.NAMES) {
            names = Lib_FDef.toNames(parser, s.substring(start));
        }
        if (phase == PHASE.PARS) {
            throw new ParseError("Invalid function definition", "Missing closing bracket: " + s, parser.getDebugInfo());
        }
        if (phase == PHASE.RETURNTYPE) {
            returnNil = false;
            returnType = s.substring(start).trim();
        }
        if (phase == PHASE.RESULT) {
            returnDef = s.substring(start).trim();
        }
        if (returnType != null && returnType.length() > 0 && !Lib_Comply.checkTypeName(returnType)) {
            throw new ParseError("Invalid function definition", "Invalid return type: " + returnType, parser.getDebugInfo());
        }
        return new FunctionInfo(names, Lib_FDef.isPrivate(names[0]), isControl, args, returnType, returnNil, returnDef);
    }

    private static enum PHASE {
        NAMES,
        PARS,
        MODIF,
        RETURNTYPE,
        RESULT;

    }
}

