/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.sys;

import java.util.Scanner;
import java.util.function.Function;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;

public class JMo_Input
extends A_Object {
    private static Scanner sc = new Scanner(System.in);
    private static Function<Class<?>, String> alternateSource = null;

    @Override
    public void init(CallRuntime cr) {
        if (alternateSource == null) {
            cr.getStrict().checkWebstart(cr, "Input");
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "str": 
            case "readStr": {
                return A_Object.stdResult(this.getStr(cr));
            }
            case "int": 
            case "readInt": {
                return A_Object.stdResult(this.getInt(cr));
            }
            case "getBool": 
            case "bool": {
                return A_Object.stdResult(this.getBool(cr));
            }
            case "dec": 
            case "readDec": {
                return A_Object.stdResult(this.getDec(cr));
            }
        }
        return null;
    }

    public static void setSource(Function<Class<?>, String> f) {
        alternateSource = f;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Input";
    }

    private I_Atomic getDec(CallRuntime cr) {
        cr.args();
        try {
            String s = this.iRead(Dec.class);
            if (s == null) {
                return Nil.NIL;
            }
            s = s.replace(',', '.');
            double d = Double.parseDouble(s);
            return new Dec(d);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    private I_Atomic getInt(CallRuntime cr) {
        cr.args();
        try {
            String s = this.iRead(Int.class);
            if (s == null) {
                return Nil.NIL;
            }
            s = s.replace(',', '.');
            int i = Integer.parseInt(s);
            return new Int(i);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    private I_Atomic getStr(CallRuntime cr) {
        cr.args();
        String s = this.iRead(Str.class);
        return s == null ? Nil.NIL : new Str(s);
    }

    public I_Atomic getBool(CallRuntime cr) {
        cr.args();
        String s = this.iRead(Bool.class);
        if (s == null) {
            return Nil.NIL;
        }
        switch (s = s.trim().toLowerCase()) {
            case "1": 
            case "true": {
                return Bool.TRUE;
            }
            case "0": 
            case "false": {
                return Bool.FALSE;
            }
        }
        return Nil.NIL;
    }

    private String iRead(Class<?> type) {
        return alternateSource == null ? sc.nextLine() : alternateSource.apply(type);
    }
}

