/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.datetime.A_DateTimeBase;
import org.jmo_lang.object.immute.datetime.JMo_Date;
import org.jmo_lang.object.immute.datetime.JMo_Time;
import org.jmo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public class JMo_DateTime
extends A_DateTimeBase {
    private I_DateTime datetime;
    private final Call[] init;

    public JMo_DateTime(I_DateTime datetime) {
        this.init = null;
        this.datetime = datetime;
    }

    public JMo_DateTime() {
        this.init = null;
        this.datetime = null;
    }

    public JMo_DateTime(Call str) {
        this.init = new Call[]{str};
        this.datetime = null;
    }

    public JMo_DateTime(Call y, Call m, Call d, Call hh, Call mm, Call ss) {
        this.init = new Call[]{y, m, d, hh, mm, ss};
        this.datetime = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init == null) {
            if (this.datetime == null) {
                this.datetime = new MDateTime();
            }
        } else {
            if (this.init.length == 1) {
                String s = Lib_Convert.getStringValue(cr, cr.execInit(this.init[0], this));
                try {
                    this.datetime = new MDateTime(s);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Can't create DateTime-Object", String.valueOf(err.getMessage()) + " Got: DateTime(" + s + ")");
                }
            }
            int iy = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], this));
            int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], this));
            int id = Lib_Convert.getIntValue(cr, cr.execInit(this.init[2], this));
            int ihh = Lib_Convert.getIntValue(cr, cr.execInit(this.init[3], this));
            int imm = Lib_Convert.getIntValue(cr, cr.execInit(this.init[4], this));
            int iss = Lib_Convert.getIntValue(cr, cr.execInit(this.init[5], this));
            try {
                this.datetime = new MDateTime(iy, im, id, ihh, imm, iss);
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, "Invalid datetime", "DateTime(" + iy + "," + im + "," + id + "," + ihh + "," + imm + "," + iss + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getYear": {
                return A_Object.stdResult(this.getYear(cr));
            }
            case "getMonth": {
                return A_Object.stdResult(this.getMonth(cr));
            }
            case "getDay": {
                return A_Object.stdResult(this.getDay(cr));
            }
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.getHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.getMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.getSeconds(cr));
            }
            case "getWeekDay": 
            case "getDayOfWeek": {
                return A_Object.stdResult(this.getDayOfWeek(cr));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.add(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.addMinutes(cr));
            }
            case "addHours": 
            case "addHour": {
                return A_Object.stdResult(this.addHours(cr));
            }
            case "addDay": 
            case "addDays": {
                return A_Object.stdResult(this.addDays(cr));
            }
            case "addMonth": 
            case "addMonths": {
                return A_Object.stdResult(this.addMonths(cr));
            }
            case "addYears": 
            case "addYear": {
                return A_Object.stdResult(this.addYears(cr));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.sub(cr, true));
            }
            case "setDay": {
                return A_Object.stdResult(this.setDay(cr));
            }
            case "setMonth": {
                return A_Object.stdResult(this.setMonth(cr));
            }
            case "setYear": {
                return A_Object.stdResult(this.setYear(cr));
            }
            case "setHour": {
                return A_Object.stdResult(this.setHour(cr));
            }
            case "setMinute": {
                return A_Object.stdResult(this.setMinute(cr));
            }
            case "setSecond": {
                return A_Object.stdResult(this.setSecond(cr));
            }
            case "getDate": {
                return A_Object.stdResult(this.getDate(cr));
            }
            case "getTime": {
                return A_Object.stdResult(this.getTime(cr));
            }
            case "diffDays": {
                return A_Object.stdResult(this.diffDays(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.diffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.diffMinutes(cr));
            }
            case "diffSeconds": 
            case "diff": {
                return A_Object.stdResult(this.diffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.datetime == null) {
            return "DateTime";
        }
        return "DateTime(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.datetime == null) {
            return "DateTime";
        }
        return this.datetime.toString();
    }

    @Override
    protected boolean[] compare2(CallRuntime cr) {
        JMo_DateTime d = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        boolean isEqual = this.datetime.isEqual(d.getInternalDateTime());
        boolean isGreater = this.datetime.isGreater(d.getInternalDateTime());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_DateTime ? this.datetime.isEqual(((JMo_DateTime)arg).getInternalDateTime()) : false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            return s.equals(this.datetime.toString()) || s.equals(this.datetime.toStringDE());
        }
        return this.equals(other);
    }

    private Int diffDays(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffDays(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int diffSeconds(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffSeconds(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int diffMinutes(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffMinutes(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int diffHours(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffHours(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int getDay(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getDay());
    }

    private Int getMonth(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getMonth());
    }

    private Int getYear(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getYear());
    }

    private Int getSeconds(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getSeconds());
    }

    private Int getMinutes(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getMinutes());
    }

    private Int getHours(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getHours());
    }

    private Int getDayOfWeek(CallRuntime cr) {
        cr.args();
        int dow = this.datetime.getDayOfWeek();
        if (dow == 0) {
            dow = 7;
        }
        return new Int(dow);
    }

    private JMo_Date getDate(CallRuntime cr) {
        return new JMo_Date(this.datetime.getDate());
    }

    private JMo_Time getTime(CallRuntime cr) {
        return new JMo_Time(this.datetime.getTime());
    }

    private I_Object add(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_DateTime date2 = this.datetime.getAddSeconds(pari);
            return new JMo_DateTime(date2);
        }
        if (arg instanceof JMo_Time) {
            int part = ((JMo_Time)arg).getInternalTime().getValueSeconds();
            I_DateTime date2 = this.datetime.getAddSeconds(part);
            return new JMo_DateTime(date2);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private I_Object sub(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, A_DateTimeBase.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_DateTime date2 = this.datetime.getAddSeconds(-pari);
            return new JMo_DateTime(date2);
        }
        if (arg instanceof JMo_Time) {
            int part = ((JMo_Time)arg).getInternalTime().getValueSeconds();
            I_DateTime date2 = this.datetime.getAddSeconds(-part);
            return new JMo_DateTime(date2);
        }
        if (arg instanceof JMo_Date) {
            I_Date pard = ((JMo_Date)arg).getInternalDate();
            int result = this.datetime.getDate().diffDays(pard);
            return new Int(-result);
        }
        if (arg instanceof JMo_DateTime) {
            long msec_other = ((JMo_DateTime)arg).getInternalDateTime().getValueMilliSec() / 1000L;
            long msec_this = this.datetime.getValueMilliSec() / 1000L;
            return new JMo_Long(msec_this - msec_other);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_DateTime addMinutes(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddMinutes(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime addHours(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddHours(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime addDays(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddDays(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime addMonths(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddMonths(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime addYears(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddYears(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime setDay(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetDay(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime setMonth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMonth(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime setYear(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetYear(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime setHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetHour(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime setMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMinute(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime setSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetSecond(pari);
        return new JMo_DateTime(dt2);
    }

    @Override
    protected A_DateTimeBase incdec2(boolean inc, int amount) {
        if (inc) {
            I_DateTime date2 = this.datetime.getAddSeconds(amount);
            return new JMo_DateTime(date2);
        }
        I_DateTime date2 = this.datetime.getAddSeconds(-amount);
        return new JMo_DateTime(date2);
    }

    @Override
    protected JMo_DateTime limit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_DateTime.class, JMo_DateTime.class);
        I_DateTime min = ((JMo_DateTime)args[0]).datetime;
        I_DateTime max = ((JMo_DateTime)args[1]).datetime;
        if (this.datetime.isGreater(max)) {
            return (JMo_DateTime)args[1];
        }
        if (min.isGreater(this.datetime)) {
            return (JMo_DateTime)args[0];
        }
        return this;
    }

    @Override
    protected I_Object style(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.args();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "DD.MM.YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "DD/MM/YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "M/DD/YYYY i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    @Override
    protected Str toStr(CallRuntime cr) {
        cr.args();
        return new Str(this.datetime.toString());
    }

    protected I_DateTime getInternalDateTime() {
        return this.datetime;
    }

    @Override
    protected I_Date getInternalDate() {
        return this.datetime.getDate();
    }

    @Override
    protected I_Time getInternalTime() {
        return this.datetime.getTime();
    }

    @Override
    protected I_Object addsub(CallRuntime cr, boolean add) {
        return add ? this.add(cr, false) : this.sub(cr, false);
    }
}

