/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.convert.ConvArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Type;

public class JMo_RandomAccessFile
extends A_Object {
    private final ArgCallBuffer cMode;
    private final ArgCallBuffer cFile;
    private String mode = "r";
    private File file = null;
    private RandomAccessFile raf = null;

    public JMo_RandomAccessFile(File f, String mode) {
        this.file = f;
        this.cFile = null;
        this.mode = mode;
        this.cMode = null;
    }

    public JMo_RandomAccessFile(Call file, Call mode) {
        this.cFile = new ArgCallBuffer(1, file);
        this.cMode = new ArgCallBuffer(2, mode);
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this);
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.cMode != null) {
            I_Object o = this.cMode.init(cr, this, Str.class);
            this.mode = Lib_Convert.getStringValue(cr, o);
            Object[] allowed = new String[]{"r", "rw", "rws", "rwd"};
            if (!Lib_Array.knows(allowed, this.mode)) {
                throw new ExecError(cr, "Invalid mode for file access", "Allowed are (" + ConvArray.toString(",", allowed) + "), but got: " + this.mode);
            }
        }
        if (this.cFile != null) {
            I_Object f = this.cFile.init(cr, this, JMo_File.class);
            this.file = ((JMo_File)f).getInternalFile();
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.mode);
        }
        catch (FileNotFoundException e) {
            throw new ExtError(cr, "File access error", e.getMessage());
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "close": {
                this.close(cr);
                return A_Object.stdResult(Nil.NIL);
            }
            case "seek": {
                this.seek(cr);
                return A_Object.stdResult(this);
            }
            case "seekStart": {
                this.seekStart(cr);
                return A_Object.stdResult(this);
            }
            case "seekEnd": {
                this.seekEnd(cr);
                return A_Object.stdResult(this);
            }
            case "getSize": {
                return this.length(cr);
            }
            case "read": {
                return this.read(cr);
            }
            case "readByte": {
                return this.readByte(cr);
            }
            case "readBytes": {
                return this.readBytes(cr);
            }
            case "readInt": {
                return this.readInt(cr);
            }
            case "readString": {
                return this.readString(cr);
            }
            case "write": {
                this.write(cr);
                return A_Object.stdResult(this);
            }
            case "writeByte": {
                this.writeByte(cr);
                return A_Object.stdResult(this);
            }
            case "writeBytes": {
                this.writeBytes(cr);
                return A_Object.stdResult(this);
            }
            case "writeInt": {
                this.writeInt(cr);
                return A_Object.stdResult(this);
            }
            case "writeString": {
                this.writeString(cr);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    private void seek(CallRuntime cr) {
        I_Object o1 = cr.args(this, I_Integer.class)[0];
        long l = Lib_Convert.getLongValue(cr, o1);
        Lib_Error.ifTooSmall(cr, 1L, l);
        try {
            this.raf.seek(l - 1L);
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    public ObjectCallResult length(CallRuntime cr) {
        cr.args();
        try {
            long len = this.raf.length();
            return A_Object.stdResult(new JMo_Long(len));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    public void seekStart(CallRuntime cr) {
        cr.args();
        try {
            this.raf.seek(0L);
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    public void seekEnd(CallRuntime cr) {
        cr.args();
        try {
            this.raf.seek(this.raf.length());
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    private ObjectCallResult read(CallRuntime cr) {
        cr.args();
        try {
            int i = this.raf.read();
            return A_Object.stdResult(new Int(i));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult readByte(CallRuntime cr) {
        cr.args();
        try {
            byte b = this.raf.readByte();
            return A_Object.stdResult(new JMo_Byte(b));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult readInt(CallRuntime cr) {
        cr.args();
        try {
            int i = this.raf.readInt();
            return A_Object.stdResult(new Int(i));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void close(CallRuntime cr) {
        cr.args();
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult readBytes(CallRuntime cr) {
        I_Object o = cr.args(this, A_IntNumber.class)[0];
        int len = Lib_Convert.getIntValue(cr, o);
        try {
            byte[] btr = new byte[len];
            this.raf.readFully(btr, 0, len);
            ArrayList<I_Object> al = new ArrayList<I_Object>(len);
            int i = 0;
            while (i < len) {
                al.add(new JMo_Byte(btr[i]));
                ++i;
            }
            return A_Object.stdResult(new JMo_List(al));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult readString(CallRuntime cr) {
        I_Object[] o = cr.args(this, A_IntNumber.class, Bool.class);
        int len = Lib_Convert.getIntValue(cr, o[0]);
        boolean utf8 = Lib_Convert.getBoolValue(cr, o[1]);
        StringBuilder sb = new StringBuilder();
        try {
            if (this.raf.getFilePointer() + (long)len >= this.raf.length()) {
                len = (int)(this.raf.length() - this.raf.getFilePointer());
            }
            if (utf8) {
                byte[] btr = new byte[len];
                this.raf.readFully(btr, 0, len);
                String s = new String(btr, "UTF-8");
                sb.append(s);
            } else {
                byte[] btr = new byte[len];
                this.raf.readFully(btr, 0, len);
                int i = 0;
                while (i < len) {
                    int bi = btr[i];
                    sb.append((char)(bi &= 0xFF));
                    ++i;
                }
            }
            return A_Object.stdResult(new Str(sb.toString()));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void write(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int i = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 0, 255, i, "Position to seek");
        try {
            this.raf.write(i);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void writeByte(CallRuntime cr) {
        I_Object o = cr.args(this, JMo_Byte.class)[0];
        byte b = Lib_Convert.getByteValue(cr, o);
        try {
            this.raf.writeByte(b);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void writeBytes(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        try {
            int len = oa.length;
            byte[] ba = new byte[len];
            int i = 0;
            while (i < len) {
                ba[i] = Lib_Convert.getByteValue(cr, cr.argType(oa[i], JMo_Byte.class));
                ++i;
            }
            this.raf.write(ba);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void writeInt(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int i = Lib_Convert.getIntValue(cr, o);
        try {
            this.raf.writeInt(i);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void writeString(CallRuntime cr) {
        I_Object[] o = cr.args(this, Str.class, Bool.class);
        String s = Lib_Convert.getStringValue(cr, o[0]);
        boolean utf8 = Lib_Convert.getBoolValue(cr, o[1]);
        try {
            if (utf8) {
                this.raf.write(s.getBytes("UTF-8"));
            } else {
                this.raf.writeBytes(s);
            }
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ExtError iError(CallRuntime cr, IOException e) {
        throw new ExtError(cr, "File access error", e.getMessage());
    }
}

