/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import java.io.File;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Path
extends A_Object
implements I_Object {
    private Call arg;
    private File file = null;

    public JMo_Path(Call arg) {
        Err.ifNull(arg);
        this.arg = arg;
    }

    public JMo_Path(File f) {
        this.arg = null;
        this.file = f;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg != null) {
            I_Object filename = cr.execInit(this.arg, this);
            if (!((filename = Lib_Convert.getValue(cr, filename)) instanceof Str)) {
                throw Err.invalid(filename.toStringExt(cr));
            }
            String filestr = ((Str)filename).getValue();
            this.file = new File(filestr);
            this.arg = null;
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "exists": {
                return A_Object.stdResult(this.exists(cr));
            }
            case "equals": 
            case "==": {
                return A_Object.stdResult(this.equals2(cr));
            }
            case "getParent": {
                return A_Object.stdResult(this.getParent(cr));
            }
            case "getName": {
                return A_Object.stdResult(this.getName(cr));
            }
            case "isDir": {
                return A_Object.stdResult(this.isDir(cr));
            }
            case "isFile": {
                return A_Object.stdResult(this.isFile(cr));
            }
            case "isHidden": {
                return A_Object.stdResult(this.isHidden(cr));
            }
            case "to": {
                JMo_Path f1 = this.file.isDirectory() ? new JMo_Dir(this.file) : new JMo_File(this.file);
                return A_Object.stdResult(f1);
            }
            case "toFile": {
                if (this.file != null && this.file.isDirectory()) {
                    throw new ExtError(cr, "Path to File error", "This is a directory, not a file: " + this.file.getAbsoluteFile());
                }
                JMo_File f2 = new JMo_File(this.file);
                return A_Object.stdResult(f2);
            }
            case "toDir": {
                if (this.file != null && this.file.isFile()) {
                    throw new ExtError(cr, "Path to Dir error", "This is a file, not a directory: " + this.file.getAbsoluteFile());
                }
                JMo_Dir f3 = new JMo_Dir(this.file);
                return A_Object.stdResult(f3);
            }
            case "getAbsolute": 
            case "getPath": 
            case "getAbsolutePath": {
                return A_Object.stdResult(this.getAbsolutePath(cr));
            }
        }
        return null;
    }

    public File getInternalFile() {
        return this.file;
    }

    protected void changeFile(File f) {
        this.file = f;
    }

    @Override
    public Integer compareTo2(I_Object o) {
        if (o instanceof JMo_Path) {
            return this.file.compareTo(((JMo_Path)o).file);
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.file == null) {
            return "Path()";
        }
        return "Path(\"" + this.file.getAbsolutePath().toString() + '\"' + ")";
    }

    @Override
    public String toString() {
        if (this.file == null) {
            return "Path";
        }
        return this.file.getAbsolutePath().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JMo_Path) {
            return ((JMo_Path)o).file.equals(this.file);
        }
        return super.equals(o);
    }

    private Bool equals2(CallRuntime cr) {
        JMo_Path arg = (JMo_Path)cr.args(this, JMo_Path.class)[0];
        File pf = arg.file;
        return Bool.getObject(this.file.equals(pf));
    }

    private Bool exists(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this.file.exists());
    }

    private Str getName(CallRuntime cr) {
        cr.args();
        return new Str(this.file.getName());
    }

    private JMo_Dir getParent(CallRuntime cr) {
        cr.args();
        return new JMo_Dir(this.file.getParentFile());
    }

    private Bool isDir(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this.file.isDirectory());
    }

    private Bool isFile(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this.file.isFile());
    }

    private Bool isHidden(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this.file.isHidden());
    }

    private Str getAbsolutePath(CallRuntime cr) {
        cr.args();
        String path = this.file.getAbsolutePath();
        return new Str(path);
    }
}

