/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.keypot.KeyPotList;
import de.mn77.base.error.Err;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Type;

public abstract class A_EventObject
extends A_Object {
    private KeyPotList<String, CallRuntime> eventHandlers;

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        char c0 = method.charAt(0);
        if (c0 == ':' && method.startsWith("::")) {
            String m = cr.call.method.substring(2);
            A_EventObject obj = this;
            I_Object o = Lib_Convert.getValue(cr, this);
            if (!(o instanceof A_EventObject)) {
                throw new CodeError(cr, "Invalid event-definition", "This object has no events: " + o);
            }
            obj = (A_EventObject)o;
            obj.eventAddHandler(cr, m, cr.call);
            return new ObjectCallResult(this, true);
        }
        if (c0 == '@') {
            if (cr.hasStream()) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with stream");
            }
            if (cr.hasBlock()) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with block");
            }
            if (this != cr.instance) {
                throw new CodeError(cr, "Invalid call of a event", "An event can only be started within a type definition: " + method);
            }
            return this.callEvent(cr, method);
        }
        return this.callMethod(cr, method);
    }

    public void eventAddHandler(CallRuntime cr, String event, Call c) {
        if (cr.argCount() != 0) {
            throw Err.impossible(cr, event, c);
        }
        if (this.eventHandlers == null) {
            this.eventHandlers = new KeyPotList();
        }
        if (!this.validateEvent(cr, event)) {
            throw new CodeError(cr, "Unknown event", "Got handler for: " + event);
        }
        String[] varsToCopy = cr.call.getEventCopyVars();
        CallRuntime crNew = cr.copyEventHandler(c, varsToCopy);
        this.eventHandlers.add(event, crNew);
    }

    public void eventRunRaw(CallRuntime cr, String event, I_Object blockIT) {
        Err.ifNull(cr, event, blockIT);
        if (this.eventHandlers != null && this.eventHandlers.getKeys().contains(event)) {
            I_Sequence handlersStatic = this.eventHandlers.getPot((Object)event);
            for (CallRuntime eventCR : handlersStatic) {
                I_Object result = Lib_Exec.execBlockStream(eventCR, blockIT);
                if (!(result instanceof Return)) continue;
                Lib_Exec.checkExceptionIsEnd(cr, (Return)result);
            }
        }
    }

    public void eventRun(CallRuntime cr, String event, I_Object blockIT) {
        cr.getApp().registerFork();
        try {
            try {
                this.eventRunRaw(cr, event, blockIT);
            }
            catch (Throwable t) {
                Err.show(t);
                cr.getApp().checkExit(true);
            }
        }
        finally {
            cr.getApp().checkExit(true);
        }
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this);
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public abstract void init(CallRuntime var1);

    protected abstract ObjectCallResult callMethod(CallRuntime var1, String var2);

    protected abstract boolean validateEvent(CallRuntime var1, String var2);

    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        throw new CodeError(cr, "Invalid call of a event", "This event can't be thrown this way: " + event);
    }
}

