/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.udp;

import de.mn77.lib.udp.UdpPush;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Chars;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_UdpPush
extends A_Object {
    private UdpPush udp;
    private final ArgCallBuffer par_port;

    public JMo_UdpPush(Call port) {
        this.par_port = new ArgCallBuffer(1, port);
    }

    @Override
    public void init(CallRuntime cr) {
        int port = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.udp = new UdpPush(port);
        }
        catch (IOException e) {
            throw new ExtError(cr, "UDP-Network error", e.getMessage());
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "send": {
                try {
                    this.send(cr);
                }
                catch (IOException e) {
                    throw new ExtError(cr, "UDP-Network error", e.getMessage());
                }
                return A_Object.stdResult(this);
            }
            case "close": {
                this.close(cr);
                return A_Object.stdResult(Nil.NIL);
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "UdpPush(" + this.par_port.get() + ")";
    }

    private void send(CallRuntime cr) throws IOException {
        I_Object[] oa = cr.argsExt(this, {Str.class}, {A_IntNumber.class}, {A_Chars.class, JMo_Byte.class, JMo_List.class});
        String address = Lib_Convert.getStringValue(cr, oa[0]);
        int port = Lib_Convert.getIntValue(cr, oa[1]);
        I_Object datax = oa[2];
        if (datax instanceof A_Chars) {
            String datas = Lib_Convert.getStringValue(cr, datax);
            this.udp.push(address, port, datas.getBytes());
            return;
        }
        if (datax instanceof JMo_Byte) {
            byte data = ((JMo_Byte)datax).getValue();
            this.udp.push(address, port, new byte[]{data});
            return;
        }
        if (datax instanceof JMo_List) {
            Collection al = ((JMo_List)datax).getInternalCollection();
            byte[] ba = new byte[((ArrayList)al).size()];
            int i = 0;
            while (i < ((ArrayList)al).size()) {
                ba[i] = Lib_Convert.getByteValue(cr, (I_Object)((ArrayList)al).get(i));
                ++i;
            }
            this.udp.push(address, port, ba);
            return;
        }
        throw new ExecError(cr, "Invalid type of data", "Allowed are Chars,Byte and List, but got: " + datax.getTypeName());
    }

    private void close(CallRuntime cr) {
        cr.args();
        try {
            this.udp.close();
        }
        catch (SocketException e) {
            throw new ExtError(cr, "UDP-Network error", e.getMessage());
        }
    }
}

