/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.swing.tools;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.object.A_ObjectSimple;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Java;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Swing_Font
extends A_ObjectSimple {
    private final ArgCallBuffer par_name;
    private final ArgCallBuffer par_size;
    private String name = "SansSerif";
    private int size = 16;
    private boolean bold = false;
    private boolean italic = false;

    public JMo_Swing_Font() {
        this.par_name = null;
        this.par_size = null;
    }

    public JMo_Swing_Font(Call fontname, Call size) {
        this.par_name = new ArgCallBuffer(1, fontname);
        this.par_size = new ArgCallBuffer(2, size);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par_name != null) {
            this.name = Lib_Convert.getStringValue(cr, this.par_name.init(cr, this, Str.class));
        }
        if (this.par_size != null) {
            this.size = Lib_Convert.getIntValue(cr, this.par_size.init(cr, this, A_IntNumber.class));
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "allFonts": {
                return this.getAll();
            }
            case "plain": {
                this.bold = false;
                this.italic = false;
                return this;
            }
            case "bold": {
                this.bold = true;
                return this;
            }
            case "italic": {
                this.italic = true;
                return this;
            }
        }
        return null;
    }

    public Font getFont() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        }
        if (this.italic) {
            style |= 2;
        }
        return new Font(this.name, style, this.size);
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this.getClass(), this);
    }

    private JMo_List getAll() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontList = ge.getAvailableFontFamilyNames();
        return (JMo_List)Lib_Java.javaToJmo(fontList);
    }
}

