/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing.lib;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.MFileSys;
import de.mn77.lib.config.PropertiesFile;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jmo_lang.ide.swing.action.EVENTS;
import org.jmo_lang.ide.swing.action.JayMo_Actions;

public class RecentFiles {
    private static final int MAX_ITEMS = 20;
    private PropertiesFile prop = null;
    private JayMo_Actions actions = null;
    private ArrayList<File> files = null;

    public void init(JayMo_Actions actions) {
        this.actions = actions;
        try {
            I_Directory dir = MFileSys.dirCache_MN77("JayMo");
            this.prop = new PropertiesFile("", dir.fileFlex("recent", "list"));
            this.prop.read(false);
            int amount = this.prop.getIntegerStd("files", 0);
            this.files = new ArrayList(amount);
            int i = 1;
            while (i <= amount) {
                File f;
                String s = this.prop.getStringStd("file" + i, null);
                if (s != null && (f = new File(s)).exists()) {
                    this.files.add(f);
                }
                ++i;
            }
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
    }

    public void add(File f) {
        if (this.files.contains(f)) {
            this.files.remove(f);
        }
        this.files.add(f);
        while (this.files.size() > 20) {
            this.files.remove(0);
        }
        try {
            int amount = this.files.size();
            this.prop.setInteger("files", amount);
            int i = this.files.size();
            while (i > 0) {
                this.prop.setString("file" + i, this.files.get(i - 1).getAbsolutePath());
                --i;
            }
            this.prop.write();
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
    }

    public void show(JComponent comp) {
        JPopupMenu menu = new JPopupMenu();
        int i = this.files.size() - 1;
        while (i >= 0) {
            File f = this.files.get(i);
            String name = f.getName();
            if (name.endsWith(".jmo")) {
                name = name.substring(0, name.length() - 4);
            }
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(e -> {
                ActionEvent event2 = new ActionEvent(e.getSource(), e.getID(), String.valueOf(EVENTS.LOAD.name()) + " " + f.getAbsolutePath());
                this.actions.actionPerformed(event2);
            });
            menu.add(item);
            --i;
        }
        menu.show(comp, 0, comp.getHeight());
    }
}

