/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing.defs;

import java.io.File;
import org.jmo_lang.ide.swing.action.EVENTS;
import org.jmo_lang.ide.swing.action.JayMo_Actions;
import org.jmo_lang.ide.swing.edit.CodeEditor;
import org.jmo_lang.ide.swing.edit.styler.Styler;
import org.jmo_lang.ide.swing.lib.RecentFiles;

public class FileEditor
extends CodeEditor {
    private static final long serialVersionUID = 7841170632314601549L;
    private File currentFile = null;
    private boolean isChanged = false;
    private final JayMo_Actions actions;
    private final RecentFiles recent;

    public FileEditor(int font_char_width, int font_line_hight, JayMo_Actions actions) {
        super(font_char_width, font_line_hight);
        this.setStyler(new Styler(this));
        this.actions = actions;
        this.recent = new RecentFiles();
        this.recent.init(actions);
    }

    public void setChanged(boolean b) {
        boolean updateNeeded = b ^ this.isChanged;
        this.isChanged = b;
        if (updateNeeded) {
            this.actions.perform(EVENTS.CHANGED);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File f) {
        this.currentFile = f;
        this.actions.perform(EVENTS.CHANGED);
    }

    public boolean hasUnsavedChanges() {
        return this.isChanged && (this.currentFile != null || this.getText().trim().length() > 0);
    }

    public RecentFiles getRecent() {
        return this.recent;
    }
}

