/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing.action;

import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.A_ParallelProcess;
import org.jmo_lang.core.App;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.ide.swing.App_IDE_Swing;
import org.jmo_lang.ide.swing.defs.EditorMainPanel;
import org.jmo_lang.ide.swing.defs.TextOutput;
import org.jmo_lang.ide.swing.defs.TextResult;
import org.jmo_lang.parser.Parser_App;

public class ExecutionControl {
    protected static final String TEXT_END_ERROR = "Process ended with error.";
    private final Parser_App parser = new Parser_App();
    private App runningApp = null;
    private Thread runningThread = null;

    public void execute(final String sourceCode, final App_IDE_Swing frame, final EditorMainPanel compMain, final Procedure onFinish) {
        final TextOutput compOutput = compMain.getComponentOutput();
        final TextResult compResult = compMain.getComponentResult();
        if (this.runningThread != null) {
            return;
        }
        this.runningThread = new A_ParallelProcess(){

            @Override
            protected void onFinished() {
                onFinish.execute();
                ExecutionControl.this.runningApp = null;
                ExecutionControl.this.runningThread = null;
            }

            @Override
            protected void process() {
                if (ExecutionControl.this.runningApp != null) {
                    return;
                }
                App app = null;
                compOutput.setText("");
                compResult.showMessage("");
                compMain.showOutput();
                try {
                    app = ExecutionControl.this.parser.parseText(">strictWebstart");
                    ExecutionControl.this.parser.parseText(app, sourceCode);
                    ExecutionControl.this.runningApp = app;
                    app.setOutputRedirection(s -> {
                        compOutput.append((String)s);
                        compOutput.setCaretPosition(compOutput.getText().length());
                        compOutput.repaint();
                    });
                    app.setNoHardExit();
                    Stopwatch timer = new Stopwatch();
                    String result = app.exec(null);
                    if (!app.toBeTerminated()) {
                        compResult.showMessage(result);
                        frame.setStatus("Runtime: " + ExecutionControl.this.iTimeMMSSsss(timer.getMillisec()));
                    }
                }
                catch (Err_FileSys e) {
                    compOutput.setText(e.toString());
                    compResult.showMessage("Error");
                    frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                    Err.show(e);
                }
                catch (ErrorBaseDebug ce) {
                    if (app == null || !app.toBeTerminated()) {
                        compOutput.setText(ce.toInfo());
                        compResult.showMessage("Error");
                        frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                        Err.show(ce);
                    }
                }
                catch (Throwable t) {
                    compOutput.setText(t.toString());
                    compResult.showMessage("Error");
                    frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                    Err.show(t);
                }
            }
        };
    }

    public void reset() {
        if (this.runningApp != null) {
            this.runningApp.terminate();
        }
        Sys.sleep(100);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
        Sys.sleep(100);
        try {
            if (this.runningThread != null) {
                this.runningThread.stop();
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    private String iTimeMMSSsss(long time) {
        int ms = (int)(time % 1000L);
        int ss = (int)(time /= 1000L);
        return ss == 0 ? ms + " ms" : String.valueOf(ss) + "." + ms + " Sec.";
    }
}

